/*
 * Decompiled with CFR 0.152.
 */
package tr.data;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Logger;
import org.openide.modules.ModuleInstall;
import org.openide.windows.WindowManager;
import tr.datastore.DataStore;
import tr.datastore.DataStoreLookup;
import tr.datastore.xstream.XStreamDataStore;
import tr.view.WindowUtils;

public class Installer
extends ModuleInstall {
    private static final Logger LOG = Logger.getLogger("tr.data");

    public void restored() {
        this.loadDatastore();
    }

    private void loadDatastore() {
        DataStore ds = XStreamDataStore.instance();
        DataStoreLookup.instance().setDataStore(ds);
        try {
            ds.load();
            ds.startDaemon();
        }
        catch (Exception ex) {
            LOG.severe("Data store could not load data. " + ex.getMessage());
        }
        final String path = ds == null || !ds.isLoaded() ? "" : ds.getPath();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                WindowManager.getDefault().getMainWindow().addWindowListener(new WindowAdapter(){

                    public void windowOpened(WindowEvent e) {
                        super.windowOpened(e);
                        ((Frame)e.getSource()).setTitle("ThinkingRock " + path);
                        if (path.equals("")) {
                            WindowUtils.openOverviewWindow();
                        } else {
                            WindowUtils.openInitialWindow();
                        }
                    }
                });
            }
        });
    }

    public boolean closing() {
        WindowUtils.closeWindows();
        return super.closing();
    }

    public void close() {
        DataStore ds = (DataStore)DataStoreLookup.instance().lookup(DataStore.class);
        if (ds != null) {
            ds.stopDaemon();
            try {
                ds.store();
            }
            catch (Exception ex) {
                LOG.severe("Data store could not store data. " + ex.getMessage());
            }
        }
        super.close();
    }
}

