/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.ByteArray;
import com.sun.mail.iap.ConnectionException;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.imap.IMAPMessage;
import com.sun.mail.imap.protocol.BODY;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.util.FolderClosedIOException;
import com.sun.mail.util.MessageRemovedIOException;
import java.io.IOException;
import java.io.InputStream;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.MessagingException;

public class IMAPInputStream
extends InputStream {
    private IMAPMessage msg;
    private String section;
    private int pos;
    private int blksize;
    private int max;
    private byte[] buf;
    private int bufcount;
    private int bufpos;
    private boolean peek;
    private ByteArray readbuf;
    private static final int slop = 64;

    public IMAPInputStream(IMAPMessage iMAPMessage, String string, int n, boolean bl) {
        this.msg = iMAPMessage;
        this.section = string;
        this.max = n;
        this.peek = bl;
        this.pos = 0;
        this.blksize = iMAPMessage.getFetchBlockSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceCheckExpunged() throws MessageRemovedIOException, FolderClosedIOException {
        Object object = this.msg.getMessageCacheLock();
        synchronized (object) {
            try {
                this.msg.getProtocol().noop();
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedIOException(this.msg.getFolder(), connectionException.getMessage());
            }
            catch (FolderClosedException folderClosedException) {
                throw new FolderClosedIOException(folderClosedException.getFolder(), folderClosedException.getMessage());
            }
            catch (ProtocolException protocolException) {
                // empty catch block
            }
        }
        if (this.msg.isExpunged()) {
            throw new MessageRemovedIOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fill() throws IOException {
        ByteArray byteArray;
        if (this.max != -1 && this.pos >= this.max) {
            if (this.pos == 0) {
                this.checkSeen();
            }
            this.readbuf = null;
            return;
        }
        BODY bODY = null;
        if (this.readbuf == null) {
            this.readbuf = new ByteArray(this.blksize + 64);
        }
        Object object = this.msg.getMessageCacheLock();
        synchronized (object) {
            try {
                IMAPProtocol iMAPProtocol = this.msg.getProtocol();
                if (this.msg.isExpunged()) {
                    throw new MessageRemovedIOException("No content for expunged message");
                }
                int n = this.msg.getSequenceNumber();
                int n2 = this.blksize;
                if (this.max != -1 && this.pos + this.blksize > this.max) {
                    n2 = this.max - this.pos;
                }
                bODY = this.peek ? iMAPProtocol.peekBody(n, this.section, this.pos, n2, this.readbuf) : iMAPProtocol.fetchBody(n, this.section, this.pos, n2, this.readbuf);
            }
            catch (ProtocolException protocolException) {
                this.forceCheckExpunged();
                throw new IOException(protocolException.getMessage());
            }
            catch (FolderClosedException folderClosedException) {
                throw new FolderClosedIOException(folderClosedException.getFolder(), folderClosedException.getMessage());
            }
            if (bODY == null || (byteArray = bODY.getByteArray()) == null) {
                this.forceCheckExpunged();
                throw new IOException("No content");
            }
        }
        if (this.pos == 0) {
            this.checkSeen();
        }
        this.buf = byteArray.getBytes();
        this.bufpos = byteArray.getStart();
        int n = byteArray.getCount();
        this.bufcount = this.bufpos + n;
        this.pos += n;
    }

    public synchronized int read() throws IOException {
        if (this.bufpos >= this.bufcount) {
            this.fill();
            if (this.bufpos >= this.bufcount) {
                return -1;
            }
        }
        return this.buf[this.bufpos++] & 0xFF;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.bufcount - this.bufpos;
        if (n3 <= 0) {
            this.fill();
            n3 = this.bufcount - this.bufpos;
            if (n3 <= 0) {
                return -1;
            }
        }
        int n4 = n3 < n2 ? n3 : n2;
        System.arraycopy(this.buf, this.bufpos, byArray, n, n4);
        this.bufpos += n4;
        return n4;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public synchronized int available() throws IOException {
        return this.bufcount - this.bufpos;
    }

    private void checkSeen() {
        if (this.peek) {
            return;
        }
        try {
            Folder folder = this.msg.getFolder();
            if (folder != null && folder.getMode() != 1 && !this.msg.isSet(Flags.Flag.SEEN)) {
                this.msg.setFlag(Flags.Flag.SEEN, true);
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }
}

