/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.orthogonalsupport;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.graph.layout.UniversalGraph;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MGraph<N, E> {
    private Collection<N> nodes;
    private Map<N, Vertex> vertexMap;
    private Map<E, Edge> edgeMap;
    private Collection<Vertex> vertices;
    private Collection<Edge> edges;
    private UniversalGraph<N, E> uGraph = null;
    private GraphScene scene = null;

    protected MGraph(UniversalGraph<N, E> universalGraph, GraphScene graphScene) {
        this.uGraph = universalGraph;
        this.scene = graphScene;
        this.nodes = universalGraph.getNodes();
        this.vertexMap = new HashMap<N, Vertex>();
        this.edgeMap = new LinkedHashMap<E, Edge>();
        this.vertices = new ArrayList<Vertex>();
        DummyVertex.resetCounter();
    }

    public static <N, E> MGraph createGraph(UniversalGraph<N, E> universalGraph, GraphScene graphScene) {
        MGraph<N, E> mGraph = new MGraph<N, E>(universalGraph, graphScene);
        mGraph.createGraph();
        return mGraph;
    }

    protected void createGraph() {
        for (N n : this.nodes) {
            Edge edge;
            Vertex vertex;
            N n2;
            Vertex vertex2 = this.getVertex(n);
            Widget widget = this.scene.findWidget(n);
            Rectangle rectangle = widget.getBounds();
            Dimension dimension = new Dimension(rectangle.width, rectangle.height);
            vertex2.setSize(dimension);
            Collection<E> collection = this.uGraph.findNodeEdges(n, true, false);
            for (E e : collection) {
                n2 = this.uGraph.getEdgeTarget(e);
                vertex = this.getVertex(n2);
                edge = this.getEdge(e, vertex2, vertex);
                vertex2.addNeighbor(vertex);
                vertex2.addEdge(edge);
                vertex.addEdge(edge);
            }
            collection = this.uGraph.findNodeEdges(n, false, true);
            for (E e : collection) {
                n2 = this.uGraph.getEdgeSource(e);
                vertex = this.getVertex(n2);
                edge = this.getEdge(e, vertex, vertex2);
                vertex2.addNeighbor(vertex);
                vertex2.addEdge(edge);
                vertex.addEdge(edge);
            }
        }
    }

    public Collection<Vertex> getVertices() {
        return Collections.unmodifiableCollection(this.vertices);
    }

    public Collection<Edge> getEdges() {
        return Collections.unmodifiableCollection(this.edgeMap.values());
    }

    protected Vertex getVertex(N n) {
        Vertex vertex = this.vertexMap.get(n);
        if (vertex == null) {
            vertex = this.createVertex(n);
            this.vertexMap.put(n, vertex);
            this.vertices.add(vertex);
        }
        return vertex;
    }

    protected Vertex createVertex(N n) {
        return new Vertex<N>(n);
    }

    protected Edge getEdge(E e, Vertex vertex, Vertex vertex2) {
        Edge edge = this.edgeMap.get(e);
        if (edge == null) {
            edge = this.createEdge(vertex, vertex2, e);
            this.edgeMap.put(e, edge);
        }
        return edge;
    }

    protected Edge createEdge(Vertex vertex, Vertex vertex2, E e) {
        return new Edge<E>(vertex, vertex2, e);
    }

    public DummyVertex insertDummyVertex(Edge edge, DummyVertex.Type type) {
        Edge edge2 = edge;
        if (edge instanceof DummyEdge) {
            edge2 = ((DummyEdge)edge).getOriginalEdge();
        }
        DummyVertex dummyVertex = this.createDummyVertex(edge2, type);
        this.vertices.add(dummyVertex);
        Vertex vertex = edge.getV();
        Vertex vertex2 = edge.getW();
        vertex.removeEdge(edge);
        vertex.removeNeighbor(vertex2);
        vertex.addNeighbor(dummyVertex);
        dummyVertex.addNeighbor(vertex);
        DummyEdge dummyEdge = this.createDummyEdge(vertex, dummyVertex, edge2);
        vertex.addEdge(dummyEdge);
        dummyVertex.addEdge(dummyEdge);
        vertex2.removeEdge(edge);
        vertex2.removeNeighbor(vertex);
        vertex2.addNeighbor(dummyVertex);
        dummyVertex.addNeighbor(vertex2);
        dummyEdge = this.createDummyEdge(dummyVertex, vertex2, edge2);
        vertex2.addEdge(dummyEdge);
        dummyVertex.addEdge(dummyEdge);
        return dummyVertex;
    }

    protected DummyVertex createDummyVertex(Edge edge, DummyVertex.Type type) {
        return new DummyVertex(edge, type);
    }

    public DummyEdge addDummyEdge(Vertex vertex, Vertex vertex2) {
        DummyEdge dummyEdge = this.createDummyEdge(vertex, vertex2, null);
        vertex.addEdge(dummyEdge);
        vertex2.addEdge(dummyEdge);
        vertex.addNeighbor(vertex2);
        vertex2.addNeighbor(vertex);
        return dummyEdge;
    }

    protected DummyEdge createDummyEdge(Vertex vertex, Vertex vertex2, Edge edge) {
        return new DummyEdge(vertex, vertex2, edge);
    }

    public DummyVertex addDummyVertex(DummyVertex.Type type) {
        DummyVertex dummyVertex = this.createDummyVertex(null, type);
        this.vertices.add(dummyVertex);
        return dummyVertex;
    }

    public void printGraph() {
        int n = 0;
        for (Vertex object : this.getVertices()) {
            Object object22;
            Logger.log(1, n + ") vertex = " + object + " (" + object.getX() + ", " + object.getY() + ")");
            ++n;
            Object n2 = object.getNodeDesignElement();
            if (n2 == null) continue;
            Collection<E> collection = this.uGraph.findNodeEdges(n2, true, false);
            Logger.log(1, "\toutgoing edges:");
            for (Object object22 : collection) {
                Logger.log(1, "\t\t" + object22);
            }
            collection = this.uGraph.findNodeEdges(n2, false, true);
            Logger.log(1, "\tincoming edges:");
            for (Object object22 : collection) {
                Logger.log(1, "\t\t" + object22);
            }
            Logger.log(1, "\tneighbors:");
            Collection<Vertex> collection2 = object.getNeighbors();
            object22 = collection2.iterator();
            while (object22.hasNext()) {
                Vertex vertex = (Vertex)object22.next();
                Logger.log(1, "\t\t" + vertex);
            }
        }
        Logger.log(1, "------------------\n------------------");
        n = 0;
        for (Edge edge : this.getEdges()) {
            Logger.log(1, n + ") edge = " + edge);
            ++n;
        }
    }

    public static class DummyEdge
    extends Edge {
        private Edge originalEdge;

        public DummyEdge(Vertex vertex, Vertex vertex2, Edge edge) {
            super(vertex, vertex2, null);
            this.originalEdge = edge;
        }

        public DummyEdge(Vertex vertex, Vertex vertex2) {
            this(vertex, vertex2, null);
        }

        public void setOriginalEdge(Edge edge) {
            this.originalEdge = edge;
        }

        public Edge getOriginalEdge() {
            return this.originalEdge;
        }

        public String toString() {
            return "dummy " + super.toString();
        }
    }

    public static class DummyVertex
    extends Vertex {
        private static int counter = 0;
        private Edge originalEdge;
        private Type type;
        private int index;

        public DummyVertex(Edge edge, Type type) {
            super(null);
            this.originalEdge = edge;
            this.type = type;
            this.index = --counter;
        }

        public DummyVertex(Type type) {
            this(null, type);
        }

        public static void resetCounter() {
            counter = 0;
        }

        public void setOriginalEdge(Edge edge) {
            this.originalEdge = edge;
        }

        public Edge getOriginalEdge() {
            return this.originalEdge;
        }

        public Type getType() {
            return this.type;
        }

        public String toString() {
            return "dummy vertex " + this.index;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            CROSSING,
            HYPEREDGE,
            BEND,
            TEMPORARY;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Edge<E> {
        private Vertex v;
        private Vertex w;
        private E edge;
        private Direction direction;
        private int weight;
        private Object edgeData;

        public Edge(Vertex vertex, Vertex vertex2, E e) {
            this.v = vertex;
            this.w = vertex2;
            this.edge = e;
        }

        public Vertex getV() {
            return this.v;
        }

        public Vertex getW() {
            return this.w;
        }

        public int getWeight() {
            return this.weight;
        }

        public void setWeight(int n) {
            this.weight = n;
        }

        public E getEdgeDesignElement() {
            return this.edge;
        }

        public void setEdgeData(Object object) {
            this.edgeData = object;
        }

        public Object getEdgeData() {
            return this.edgeData;
        }

        public boolean contains(Vertex vertex) {
            return this.v == vertex || this.w == vertex;
        }

        public boolean shareVertex(Edge edge) {
            return this.contains(edge.v) || this.contains(edge.w);
        }

        public Vertex getOppositeVertex(Vertex vertex) {
            if (this.v == vertex) {
                return this.w;
            }
            if (this.w == vertex) {
                return this.v;
            }
            return null;
        }

        public void setDirection(Direction direction) {
            this.direction = direction;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public String toString() {
            return "edge : " + this.edge + "\n  v = " + this.v + "\n  w = " + this.w;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Direction {
            HORIZONTAL,
            VERTICAL,
            UP,
            DOWN,
            LEFT,
            RIGHT;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Vertex<N> {
        private N node;
        private Collection<Vertex> neighbors;
        private Collection<Edge> edges;
        private int number = -1;
        private Object vertexData;
        private float x;
        private float y;
        private Dimension size = null;

        public Vertex(N n) {
            this.node = n;
            this.neighbors = new LinkedHashSet<Vertex>();
            this.edges = new LinkedHashSet<Edge>();
        }

        public Dimension getSize() {
            return this.size;
        }

        public void setSize(Dimension dimension) {
            this.size = dimension;
        }

        public float getX() {
            return this.x;
        }

        public void setX(float f) {
            this.x = f;
        }

        public float getY() {
            return this.y;
        }

        public void setY(float f) {
            this.y = f;
        }

        public void addNeighbor(Vertex vertex) {
            this.neighbors.add(vertex);
        }

        public void removeNeighbor(Vertex vertex) {
            this.neighbors.remove(vertex);
        }

        public Collection<Vertex> getNeighbors() {
            return this.neighbors;
        }

        public Edge getEdge(Vertex vertex) {
            for (Edge edge : this.edges) {
                if (!edge.contains(vertex)) continue;
                return edge;
            }
            return null;
        }

        public void addEdge(Edge edge) {
            this.edges.add(edge);
        }

        public void removeEdge(Edge edge) {
            this.edges.remove(edge);
        }

        public Collection<Edge> getEdges() {
            return this.edges;
        }

        public N getNodeDesignElement() {
            return this.node;
        }

        public int getDegree() {
            return this.neighbors.size();
        }

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int n) {
            this.number = n;
        }

        public void setVertexData(Object object) {
            this.vertexData = object;
        }

        public Object getVertexData() {
            return this.vertexData;
        }

        public String toString() {
            return "vertex : " + this.node;
        }
    }
}

