/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;

public class ReaderInputStream
extends InputStream {
    private Reader reader;
    private PipedOutputStream pos;
    private PipedInputStream pis;
    private OutputStreamWriter osw;

    public ReaderInputStream(Reader reader) throws IOException {
        this.reader = reader;
        this.pos = new PipedOutputStream();
        this.pis = new PipedInputStream(this.pos);
        this.osw = new OutputStreamWriter(this.pos);
    }

    public ReaderInputStream(Reader reader, String string) throws IOException {
        this.reader = reader;
        this.pos = new PipedOutputStream();
        this.pis = new PipedInputStream(this.pos);
        this.osw = new OutputStreamWriter((OutputStream)this.pos, string);
    }

    public int read() throws IOException {
        if (this.pis.available() > 0) {
            return this.pis.read();
        }
        int n = this.reader.read();
        if (n == -1) {
            return n;
        }
        this.osw.write(n);
        this.osw.flush();
        this.pos.flush();
        return this.pis.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 == 0) {
            return 0;
        }
        int n4 = this.read();
        if (n4 == -1) {
            return -1;
        }
        byArray[n] = (byte)n4;
        for (n3 = 1; n3 < n2 && this.reader.ready(); ++n3) {
            n4 = this.read();
            if (n4 == -1) {
                return n3;
            }
            byArray[n + n3] = (byte)n4;
        }
        return n3;
    }

    public int available() throws IOException {
        int n = this.pis.available();
        if (n > 0) {
            return n;
        }
        if (this.reader.ready()) {
            return 1;
        }
        return 0;
    }

    public void close() throws IOException {
        this.reader.close();
        this.osw.close();
        this.pis.close();
    }
}

