/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.core.startup.layers.ModuleLayeredFileSystem;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class ArchiveURLMapper
extends URLMapper {
    private static boolean warningAlreadyReported = false;
    private static final String JAR_PROTOCOL = "jar";
    private static Map<File, SoftReference<JarFileSystem>> mountRoots = new HashMap<File, SoftReference<JarFileSystem>>();

    public URL getURL(FileObject fileObject, int n) {
        assert (fileObject != null);
        if ((n == 1 || n == 0) && fileObject.isValid()) {
            try {
                JarFileSystem jarFileSystem;
                File file;
                FileSystem fileSystem = fileObject.getFileSystem();
                if (fileSystem instanceof JarFileSystem && ArchiveURLMapper.isRoot(file = (jarFileSystem = (JarFileSystem)fileSystem).getJarFile())) {
                    return new URL("jar:" + file.toURI() + "!/" + fileObject.getPath() + (fileObject.isFolder() && !fileObject.isRoot() ? "/" : ""));
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return null;
    }

    public FileObject[] getFileObjects(URL uRL) {
        String string;
        int n;
        assert (uRL != null);
        String string2 = uRL.getProtocol();
        if (JAR_PROTOCOL.equals(string2) && (n = (string = uRL.getPath()).lastIndexOf(33)) >= 0) {
            try {
                URI uRI = new URI(string.substring(0, n));
                if (!uRI.isAbsolute() || uRI.isOpaque()) {
                    return null;
                }
                FileObject fileObject = URLMapper.findFileObject((URL)uRI.toURL());
                if (fileObject == null || fileObject.isVirtual()) {
                    return null;
                }
                File file = FileUtil.toFile((FileObject)fileObject);
                if (file == null) {
                    return null;
                }
                String string3 = string.length() > n + 2 ? URLDecoder.decode(string.substring(n + 2), "UTF-8") : "";
                JarFileSystem jarFileSystem = ArchiveURLMapper.getFileSystem(file);
                FileObject fileObject2 = jarFileSystem.findResource(string3);
                if (fileObject2 != null) {
                    return new FileObject[]{fileObject2};
                }
            }
            catch (IOException iOException) {
                if (warningAlreadyReported) {
                    ModuleLayeredFileSystem.err.log(Level.INFO, null, iOException);
                } else {
                    ModuleLayeredFileSystem.err.log(Level.WARNING, null, iOException);
                    warningAlreadyReported = true;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                Exceptions.printStackTrace((Throwable)uRISyntaxException);
            }
        }
        return null;
    }

    private static synchronized boolean isRoot(File file) {
        return mountRoots.containsKey(file);
    }

    private static synchronized JarFileSystem getFileSystem(File file) throws IOException {
        Reference reference = mountRoots.get(file);
        JarFileSystem jarFileSystem = null;
        if (reference == null || (jarFileSystem = (JarFileSystem)reference.get()) == null) {
            jarFileSystem = ArchiveURLMapper.findJarFileSystemInRepository(file);
            if (jarFileSystem == null) {
                try {
                    jarFileSystem = new JarFileSystem();
                    File file2 = FileUtil.normalizeFile((File)file);
                    jarFileSystem.setJarFile(file2);
                }
                catch (PropertyVetoException propertyVetoException) {
                    throw new AssertionError((Object)propertyVetoException);
                }
            }
            mountRoots.put(file, new JFSReference(jarFileSystem));
        }
        return jarFileSystem;
    }

    private static JarFileSystem findJarFileSystemInRepository(File file) {
        Enumeration enumeration = Repository.getDefault().getFileSystems();
        while (enumeration.hasMoreElements()) {
            JarFileSystem jarFileSystem;
            FileSystem fileSystem = (FileSystem)enumeration.nextElement();
            if (!(fileSystem instanceof JarFileSystem) || !file.equals((jarFileSystem = (JarFileSystem)fileSystem).getJarFile())) continue;
            return jarFileSystem;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JFSReference
    extends SoftReference<JarFileSystem> {
        private FileChangeListener fcl;

        public JFSReference(JarFileSystem jarFileSystem) {
            super(jarFileSystem);
            final File file = jarFileSystem.getJarFile();
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject != null) {
                this.fcl = new FileChangeAdapter(){

                    public void fileDeleted(FileEvent fileEvent) {
                        JFSReference.this.releaseMe(file);
                    }

                    public void fileRenamed(FileRenameEvent fileRenameEvent) {
                        JFSReference.this.releaseMe(file);
                    }
                };
                fileObject.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.fcl, (Object)fileObject));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void releaseMe(File file) {
            JarFileSystem jarFileSystem = (JarFileSystem)this.get();
            if (jarFileSystem == null) return;
            Class<ArchiveURLMapper> clazz = ArchiveURLMapper.class;
            synchronized (ArchiveURLMapper.class) {
                File file2 = file != null ? file : jarFileSystem.getJarFile();
                mountRoots.remove(file2);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
    }
}

