/*
 * Decompiled with CFR 0.152.
 */
package tr.model.topic;

import java.util.Iterator;
import java.util.logging.Logger;
import tr.model.Data;
import tr.model.Item.Item;
import tr.model.action.Action;
import tr.model.future.Future;
import tr.model.information.Information;
import tr.model.project.Project;
import tr.model.thought.Thought;
import tr.model.topic.Topic;

public class TopicUtils {
    private static final Logger LOG = Logger.getLogger("tr.model.topic");
    private static TopicUtils instance;

    private TopicUtils() {
    }

    public static synchronized TopicUtils instance() {
        if (instance == null) {
            instance = new TopicUtils();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUsed(Data data, Topic topic) {
        TopicUtils topicUtils = this;
        synchronized (topicUtils) {
            if (data == null || topic == null) {
                return true;
            }
            return this.isUsedTopic(data, topic);
        }
    }

    private boolean isUsedTopic(Data data, Topic topic) {
        if (topic.equals(Topic.getDefault())) {
            return true;
        }
        Iterator<Action> i = data.getRootActions().iterator(Action.class);
        while (i.hasNext()) {
            if (!i.next().getTopic().equals(topic)) continue;
            return true;
        }
        if (this.isUsedTopic(data.getRootProjects(), topic)) {
            return true;
        }
        if (this.isUsedTopic(data.getRootFutures(), topic)) {
            return true;
        }
        if (this.isUsedTopic(data.getRootTemplates(), topic)) {
            return true;
        }
        for (Thought thought : data.getThoughtManager().list()) {
            if (!thought.getTopic().equals(topic)) continue;
            return true;
        }
        for (Future future : data.getFutureManager().list()) {
            if (!future.getTopic().equals(topic)) continue;
            return true;
        }
        for (Information info : data.getInformationManager().list()) {
            if (!info.getTopic().equals(topic)) continue;
            return true;
        }
        return false;
    }

    private boolean isUsedTopic(Project project, Topic topic) {
        if (project.getTopic().equals(topic)) {
            return true;
        }
        for (Item child : project.getChildren()) {
            if (!(child instanceof Action ? ((Action)child).getTopic().equals(topic) : child instanceof Project && this.isUsedTopic((Project)child, topic))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(Data data, Topic topic, Topic replacement) {
        TopicUtils topicUtils = this;
        synchronized (topicUtils) {
            if (data == null || topic == null || replacement == null) {
                return false;
            }
            if (topic.equals(Topic.getDefault())) {
                return false;
            }
            if (topic.equals(replacement)) {
                return false;
            }
            this.replaceTopic(data, topic, replacement);
            return true;
        }
    }

    private void replaceTopic(Data data, Topic topic, Topic replacement) {
        this.replaceTopic(data.getRootProjects(), topic, replacement);
        Iterator<Action> i = data.getRootActions().iterator(Action.class);
        while (i.hasNext()) {
            Action action = i.next();
            if (!action.getTopic().equals(topic)) continue;
            action.setTopic(replacement);
        }
        this.replaceTopic(data.getRootFutures(), topic, replacement);
        this.replaceTopic(data.getRootTemplates(), topic, replacement);
        for (Thought thought : data.getThoughtManager().list()) {
            if (!thought.getTopic().equals(topic)) continue;
            thought.setTopic(replacement);
        }
        for (Future future : data.getFutureManager().list()) {
            if (!future.getTopic().equals(topic)) continue;
            future.setTopic(replacement);
        }
        for (Information info : data.getInformationManager().list()) {
            if (!info.getTopic().equals(topic)) continue;
            info.setTopic(replacement);
        }
    }

    private void replaceTopic(Project project, Topic topic, Topic replacement) {
        if (project.getTopic().equals(topic)) {
            project.setTopic(replacement);
        }
        for (Item child : project.getChildren()) {
            if (child instanceof Action) {
                Action action = (Action)child;
                if (!action.getTopic().equals(topic)) continue;
                action.setTopic(replacement);
                continue;
            }
            if (!(child instanceof Project)) continue;
            this.replaceTopic((Project)child, topic, replacement);
        }
    }
}

