/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

public class FontUtil {
    public static int parseCSS2FontWeight(String text) {
        int weight = 400;
        try {
            weight = Integer.parseInt(text);
            weight = weight / 100 * 100;
            weight = Math.max(weight, 100);
            weight = Math.min(weight, 900);
        }
        catch (NumberFormatException nfe) {
            if (text.equals("normal")) {
                weight = 400;
            }
            if (text.equals("bold")) {
                weight = 700;
            }
            throw new IllegalArgumentException("Illegal value for font weight: '" + text + "'. Use one of: 100, 200, 300, " + "400, 500, 600, 700, 800, 900, " + "normal (=400), bold (=700)");
        }
        return weight;
    }
}

