/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.Ordered;
import org.springframework.security.config.SecurityConfigurationException;

class LdapConfigUtils {
    static /* synthetic */ Class class$org$springframework$security$ldap$SpringSecurityContextSource;
    static /* synthetic */ Class class$org$springframework$security$config$LdapConfigUtils$ContextSourceSettingPostProcessor;

    LdapConfigUtils() {
    }

    static void registerPostProcessorIfNecessary(BeanDefinitionRegistry registry, boolean defaultNameRequired) {
        if (registry.containsBeanDefinition("_contextSettingPostProcessor")) {
            if (defaultNameRequired) {
                BeanDefinition bd = registry.getBeanDefinition("_contextSettingPostProcessor");
                bd.getPropertyValues().addPropertyValue("defaultNameRequired", (Object)defaultNameRequired);
            }
            return;
        }
        RootBeanDefinition bd = new RootBeanDefinition(class$org$springframework$security$config$LdapConfigUtils$ContextSourceSettingPostProcessor == null ? (class$org$springframework$security$config$LdapConfigUtils$ContextSourceSettingPostProcessor = LdapConfigUtils.class$("org.springframework.security.config.LdapConfigUtils$ContextSourceSettingPostProcessor")) : class$org$springframework$security$config$LdapConfigUtils$ContextSourceSettingPostProcessor);
        registry.registerBeanDefinition("_contextSettingPostProcessor", (BeanDefinition)bd);
        bd.getPropertyValues().addPropertyValue("defaultNameRequired", (Object)defaultNameRequired);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ContextSourceSettingPostProcessor
    implements BeanFactoryPostProcessor,
    Ordered {
        private boolean defaultNameRequired;

        private ContextSourceSettingPostProcessor() {
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory bf) throws BeansException {
            String[] sources = bf.getBeanNamesForType(class$org$springframework$security$ldap$SpringSecurityContextSource == null ? (class$org$springframework$security$ldap$SpringSecurityContextSource = LdapConfigUtils.class$("org.springframework.security.ldap.SpringSecurityContextSource")) : class$org$springframework$security$ldap$SpringSecurityContextSource);
            if (sources.length == 0) {
                throw new SecurityConfigurationException("No SpringSecurityContextSource instances found. Have you added an <ldap-server /> element to your application context?");
            }
            if (!bf.containsBean("_securityContextSource") && this.defaultNameRequired) {
                if (sources.length > 1) {
                    throw new SecurityConfigurationException("More than one SpringSecurityContextSource instance found. Please specify a specific server id using the 'server-ref' attribute when configuring your <ldap-authentication-provider> or <ldap-user-service>.");
                }
                bf.registerAlias(sources[0], "_securityContextSource");
            }
        }

        public void setDefaultNameRequired(boolean defaultNameRequired) {
            this.defaultNameRequired = defaultNameRequired;
        }

        public int getOrder() {
            return Integer.MAX_VALUE;
        }
    }
}

