/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl.critic;

import ca.sqlpower.architect.ddl.critic.Critic;
import ca.sqlpower.architect.ddl.critic.Criticism;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class Criticizer {
    private final List<Critic> critics;

    public Criticizer(List<Critic> critics) {
        this.critics = Collections.unmodifiableList(new ArrayList<Critic>(critics));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Criticism> criticize(Object subject) {
        try {
            for (Critic c : this.critics) {
                c.start();
            }
            List<Criticism> list = this.recursivelyCriticize(subject);
            return list;
        }
        finally {
            for (Critic c : this.critics) {
                c.end();
            }
        }
    }

    private List<Criticism> recursivelyCriticize(Object root) {
        ArrayList<Criticism> criticisms = new ArrayList<Criticism>();
        if (!(root instanceof SQLDatabase)) {
            for (Critic critic : this.critics) {
                List<Criticism> newCriticisms = critic.criticize(root);
                criticisms.addAll(newCriticisms);
            }
        }
        if (root instanceof SPObject) {
            for (SPObject child : ((SPObject)root).getChildren()) {
                try {
                    if (child instanceof SQLRelationship.SQLImportedKey && ((SQLTable)root).getImportedKeys().contains(child)) {
                        continue;
                    }
                }
                catch (SQLObjectException e) {
                    throw new RuntimeException(e);
                }
                criticisms.addAll(this.recursivelyCriticize(child));
            }
        }
        return criticisms;
    }
}

