/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.Util;
import java.text.MessageFormat;
import java.util.EnumMap;
import java.util.EnumSet;

enum JDBCType {
    UNKNOWN(Category.UNKNOWN, 999, "java.lang.Object"),
    ARRAY(Category.UNKNOWN, 2003, "java.lang.Object"),
    BIGINT(Category.NUMERIC, -5, "java.lang.Long"),
    BINARY(Category.BINARY, -2, "[B"),
    BIT(Category.NUMERIC, -7, "java.lang.Boolean"),
    BLOB(Category.BLOB, 2004, "java.sql.Blob"),
    BOOLEAN(Category.NUMERIC, 16, "java.lang.Boolean"),
    CHAR(Category.CHARACTER, 1, "java.lang.String"),
    CLOB(Category.CLOB, 2005, "java.sql.Clob"),
    DATALINK(Category.UNKNOWN, 70, "java.lang.Object"),
    DATE(Category.TEMPORAL, 91, "java.sql.Date"),
    DECIMAL(Category.NUMERIC, 3, "java.math.BigDecimal"),
    DISTINCT(Category.UNKNOWN, 2001, "java.lang.Object"),
    DOUBLE(Category.NUMERIC, 8, "java.lang.Double"),
    FLOAT(Category.NUMERIC, 6, "java.lang.Double"),
    INTEGER(Category.NUMERIC, 4, "java.lang.Integer"),
    JAVA_OBJECT(Category.UNKNOWN, 2000, "java.lang.Object"),
    LONGNVARCHAR(Category.LONG_NCHARACTER, -16, "java.lang.String"),
    LONGVARBINARY(Category.LONG_BINARY, -4, "[B"),
    LONGVARCHAR(Category.LONG_CHARACTER, -1, "java.lang.String"),
    NCHAR(Category.NCHARACTER, -15, "java.lang.String"),
    NCLOB(Category.NCLOB, 2011, "java.sql.NClob"),
    NULL(Category.UNKNOWN, 0, "java.lang.Object"),
    NUMERIC(Category.NUMERIC, 2, "java.math.BigDecimal"),
    NVARCHAR(Category.NCHARACTER, -9, "java.lang.String"),
    OTHER(Category.UNKNOWN, 1111, "java.lang.Object"),
    REAL(Category.NUMERIC, 7, "java.lang.Float"),
    REF(Category.UNKNOWN, 2006, "java.lang.Object"),
    ROWID(Category.UNKNOWN, -8, "java.lang.Object"),
    SMALLINT(Category.NUMERIC, 5, "java.lang.Short"),
    SQLXML(Category.SQLXML, 2009, "java.lang.Object"),
    STRUCT(Category.UNKNOWN, 2002, "java.lang.Object"),
    TIME(Category.TEMPORAL, 92, "java.sql.Time"),
    TIMESTAMP(Category.TEMPORAL, 93, "java.sql.Timestamp"),
    TINYINT(Category.NUMERIC, -6, "java.lang.Short"),
    VARBINARY(Category.BINARY, -3, "[B"),
    VARCHAR(Category.CHARACTER, 12, "java.lang.String");

    final Category category;
    private final int intValue;
    private final String className;
    private static final EnumSet<JDBCType> signedTypes;
    private static final EnumSet<JDBCType> binaryTypes;
    private static final EnumSet<Category> textualCategories;

    final String className() {
        return this.className;
    }

    private JDBCType(Category category, int n2, String string2) {
        this.category = category;
        this.intValue = n2;
        this.className = string2;
    }

    boolean convertsTo(JDBCType jDBCType) {
        return SetterConversion.converts(this, jDBCType);
    }

    boolean convertsTo(SSType sSType) {
        return UpdaterConversion.converts(this, sSType);
    }

    static JDBCType of(int n) throws SQLServerException {
        for (JDBCType jDBCType : JDBCType.values()) {
            if (jDBCType.intValue != n) continue;
            return jDBCType;
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unknownJDBCType"));
        Object[] objectArray = new Object[]{n};
        SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), null, true);
        return UNKNOWN;
    }

    boolean isSigned() {
        return signedTypes.contains((Object)this);
    }

    boolean isBinary() {
        return binaryTypes.contains((Object)this);
    }

    boolean isTextual() {
        return textualCategories.contains((Object)this.category);
    }

    boolean isUnsupported() {
        return Category.UNKNOWN == this.category;
    }

    int asJavaSqlType() {
        if (Util.SYSTEM_SPEC_VERSION.equals("1.5")) {
            switch (this) {
                case NCHAR: {
                    return 1;
                }
                case NVARCHAR: {
                    return 12;
                }
                case LONGNVARCHAR: {
                    return -1;
                }
                case NCLOB: {
                    return 2005;
                }
                case ROWID: {
                    return 1111;
                }
                case SQLXML: {
                    return 12;
                }
            }
            return this.intValue;
        }
        return this.intValue;
    }

    static {
        signedTypes = EnumSet.of(SMALLINT, new JDBCType[]{INTEGER, BIGINT, REAL, FLOAT, DOUBLE, DECIMAL, NUMERIC});
        binaryTypes = EnumSet.of(BINARY, VARBINARY, LONGVARBINARY, BLOB);
        textualCategories = EnumSet.of(Category.CHARACTER, new Category[]{Category.LONG_CHARACTER, Category.CLOB, Category.NCHARACTER, Category.LONG_NCHARACTER, Category.NCLOB});
    }

    static enum UpdaterConversion {
        CHARACTER(Category.CHARACTER, EnumSet.of(SSType.Category.NUMERIC, new SSType.Category[]{SSType.Category.TEMPORAL, SSType.Category.CHARACTER, SSType.Category.LONG_CHARACTER, SSType.Category.NCHARACTER, SSType.Category.LONG_NCHARACTER, SSType.Category.XML, SSType.Category.BINARY, SSType.Category.LONG_BINARY, SSType.Category.UDT, SSType.Category.GUID, SSType.Category.TIMESTAMP})),
        LONG_CHARACTER(Category.LONG_CHARACTER, EnumSet.of(SSType.Category.CHARACTER, new SSType.Category[]{SSType.Category.LONG_CHARACTER, SSType.Category.NCHARACTER, SSType.Category.LONG_NCHARACTER, SSType.Category.XML, SSType.Category.BINARY, SSType.Category.LONG_BINARY})),
        CLOB(Category.CLOB, EnumSet.of(SSType.Category.LONG_CHARACTER, SSType.Category.LONG_NCHARACTER, SSType.Category.XML)),
        NCHARACTER(Category.NCHARACTER, EnumSet.of(SSType.Category.NCHARACTER, SSType.Category.LONG_NCHARACTER, SSType.Category.XML)),
        LONG_NCHARACTER(Category.LONG_NCHARACTER, EnumSet.of(SSType.Category.NCHARACTER, SSType.Category.LONG_NCHARACTER, SSType.Category.XML)),
        NCLOB(Category.NCLOB, EnumSet.of(SSType.Category.LONG_NCHARACTER, SSType.Category.XML)),
        BINARY(Category.BINARY, EnumSet.of(SSType.Category.NUMERIC, new SSType.Category[]{SSType.Category.TEMPORAL, SSType.Category.CHARACTER, SSType.Category.LONG_CHARACTER, SSType.Category.NCHARACTER, SSType.Category.LONG_NCHARACTER, SSType.Category.XML, SSType.Category.BINARY, SSType.Category.LONG_BINARY, SSType.Category.UDT, SSType.Category.TIMESTAMP, SSType.Category.GUID})),
        LONG_BINARY(Category.LONG_BINARY, EnumSet.of(SSType.Category.XML, SSType.Category.BINARY, SSType.Category.LONG_BINARY, SSType.Category.UDT)),
        BLOB(Category.BLOB, EnumSet.of(SSType.Category.LONG_BINARY, SSType.Category.XML)),
        SQLXML(Category.SQLXML, EnumSet.of(SSType.Category.XML)),
        NUMERIC(Category.NUMERIC, EnumSet.of(SSType.Category.NUMERIC, SSType.Category.CHARACTER, SSType.Category.LONG_CHARACTER, SSType.Category.NCHARACTER, SSType.Category.LONG_NCHARACTER)),
        TEMPORAL(Category.TEMPORAL, EnumSet.of(SSType.Category.TEMPORAL, SSType.Category.CHARACTER, SSType.Category.LONG_CHARACTER, SSType.Category.NCHARACTER, SSType.Category.LONG_NCHARACTER));

        private final Category from;
        private final EnumSet<SSType.Category> to;
        private static final EnumMap<Category, EnumSet<SSType.Category>> conversionMap;

        private UpdaterConversion(Category category, EnumSet<SSType.Category> enumSet) {
            this.from = category;
            this.to = enumSet;
        }

        static boolean converts(JDBCType jDBCType, SSType sSType) {
            return conversionMap.get((Object)jDBCType.category).contains((Object)sSType.category);
        }

        static {
            conversionMap = new EnumMap(Category.class);
            for (Category enum_ : Category.values()) {
                conversionMap.put(enum_, EnumSet.noneOf(SSType.Category.class));
            }
            for (Enum enum_ : UpdaterConversion.values()) {
                conversionMap.get((Object)((UpdaterConversion)enum_).from).addAll(((UpdaterConversion)enum_).to);
            }
        }
    }

    static enum SetterConversion {
        CHARACTER(Category.CHARACTER, EnumSet.of(Category.NUMERIC, new Category[]{Category.TEMPORAL, Category.CHARACTER, Category.LONG_CHARACTER, Category.NCHARACTER, Category.LONG_NCHARACTER, Category.BINARY, Category.LONG_BINARY})),
        LONG_CHARACTER(Category.LONG_CHARACTER, EnumSet.of(Category.CHARACTER, new Category[]{Category.LONG_CHARACTER, Category.NCHARACTER, Category.LONG_NCHARACTER, Category.BINARY, Category.LONG_BINARY})),
        CLOB(Category.CLOB, EnumSet.of(Category.CLOB, Category.LONG_CHARACTER, Category.LONG_NCHARACTER)),
        NCHARACTER(Category.NCHARACTER, EnumSet.of(Category.NCHARACTER, Category.LONG_NCHARACTER, Category.NCLOB)),
        LONG_NCHARACTER(Category.LONG_NCHARACTER, EnumSet.of(Category.NCHARACTER, Category.LONG_NCHARACTER)),
        NCLOB(Category.NCLOB, EnumSet.of(Category.LONG_NCHARACTER, Category.NCLOB)),
        BINARY(Category.BINARY, EnumSet.of(Category.NUMERIC, new Category[]{Category.TEMPORAL, Category.CHARACTER, Category.LONG_CHARACTER, Category.NCHARACTER, Category.LONG_NCHARACTER, Category.BINARY, Category.LONG_BINARY, Category.BLOB})),
        LONG_BINARY(Category.LONG_BINARY, EnumSet.of(Category.BINARY, Category.LONG_BINARY)),
        BLOB(Category.BLOB, EnumSet.of(Category.LONG_BINARY, Category.BLOB)),
        NUMERIC(Category.NUMERIC, EnumSet.of(Category.NUMERIC, Category.CHARACTER, Category.LONG_CHARACTER, Category.NCHARACTER, Category.LONG_NCHARACTER)),
        TEMPORAL(Category.TEMPORAL, EnumSet.of(Category.TEMPORAL, Category.CHARACTER, Category.LONG_CHARACTER, Category.NCHARACTER, Category.LONG_NCHARACTER)),
        SQLXML(Category.SQLXML, EnumSet.of(Category.SQLXML));

        private final Category from;
        private final EnumSet<Category> to;
        private static final EnumMap<Category, EnumSet<Category>> conversionMap;

        private SetterConversion(Category category, EnumSet<Category> enumSet) {
            this.from = category;
            this.to = enumSet;
        }

        static boolean converts(JDBCType jDBCType, JDBCType jDBCType2) {
            return conversionMap.get((Object)jDBCType.category).contains((Object)jDBCType2.category);
        }

        static {
            conversionMap = new EnumMap(Category.class);
            for (Category enum_ : Category.values()) {
                conversionMap.put(enum_, EnumSet.noneOf(Category.class));
            }
            for (Enum enum_ : SetterConversion.values()) {
                conversionMap.get((Object)((SetterConversion)enum_).from).addAll(((SetterConversion)enum_).to);
            }
        }
    }

    static enum Category {
        CHARACTER,
        LONG_CHARACTER,
        CLOB,
        NCHARACTER,
        LONG_NCHARACTER,
        NCLOB,
        BINARY,
        LONG_BINARY,
        BLOB,
        NUMERIC,
        TEMPORAL,
        SQLXML,
        UNKNOWN;

    }
}

