/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.beans.internal;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.resource.beans.container.spi.BeanContainer;
import org.hibernate.resource.beans.container.spi.FallbackContainedBean;
import org.hibernate.resource.beans.internal.FallbackBeanInstanceProducer;
import org.hibernate.resource.beans.spi.BeanInstanceProducer;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.service.spi.Stoppable;

public class ManagedBeanRegistryImpl
implements ManagedBeanRegistry,
BeanContainer.LifecycleOptions,
Stoppable {
    private final Map<String, ManagedBean<?>> registrations = new HashMap();
    private final BeanContainer beanContainer;

    public ManagedBeanRegistryImpl(BeanContainer beanContainer) {
        this.beanContainer = beanContainer;
    }

    @Override
    public BeanContainer getBeanContainer() {
        return this.beanContainer;
    }

    @Override
    public boolean canUseCachedReferences() {
        return true;
    }

    @Override
    public boolean useJpaCompliantCreation() {
        return true;
    }

    @Override
    public <T> ManagedBean<T> getBean(Class<T> beanClass) {
        return this.getBean(beanClass, FallbackBeanInstanceProducer.INSTANCE);
    }

    @Override
    public <T> ManagedBean<T> getBean(Class<T> beanClass, BeanInstanceProducer fallbackBeanInstanceProducer) {
        ManagedBean<?> existing = this.registrations.get(beanClass.getName());
        if (existing != null) {
            return existing;
        }
        ManagedBean<T> bean = this.createBean(beanClass, fallbackBeanInstanceProducer);
        this.registrations.put(beanClass.getName(), bean);
        return bean;
    }

    @Override
    public <T> ManagedBean<T> getBean(String beanName, Class<T> beanContract) {
        return this.getBean(beanName, beanContract, FallbackBeanInstanceProducer.INSTANCE);
    }

    @Override
    public <T> ManagedBean<T> getBean(String beanName, Class<T> beanContract, BeanInstanceProducer fallbackBeanInstanceProducer) {
        String key = beanContract.getName() + ":" + beanName;
        ManagedBean<?> existing = this.registrations.get(key);
        if (existing != null) {
            return existing;
        }
        ManagedBean<T> bean = this.createBean(beanName, beanContract, fallbackBeanInstanceProducer);
        this.registrations.put(key, bean);
        return bean;
    }

    private <T> ManagedBean<T> createBean(Class<T> beanClass, BeanInstanceProducer fallbackBeanInstanceProducer) {
        return this.beanContainer == null ? new FallbackContainedBean<T>(beanClass, fallbackBeanInstanceProducer) : this.beanContainer.getBean(beanClass, this, fallbackBeanInstanceProducer);
    }

    private <T> ManagedBean<T> createBean(String beanName, Class<T> beanContract, BeanInstanceProducer fallbackBeanInstanceProducer) {
        return this.beanContainer == null ? new FallbackContainedBean<T>(beanName, beanContract, fallbackBeanInstanceProducer) : this.beanContainer.getBean(beanName, beanContract, this, fallbackBeanInstanceProducer);
    }

    @Override
    public void stop() {
        if (this.beanContainer != null) {
            this.beanContainer.stop();
        }
        this.registrations.clear();
    }
}

