/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.storage;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.sql.DataSource;
import liquibase.Contexts;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.resource.DirectoryResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.storage.DatabaseLockException;

public class DatabaseModule
extends AbstractModule {
    @Singleton
    @Provides
    public static DataSource provideDataSource(Config config) throws ReflectiveOperationException, IOException, LiquibaseException {
        String driver;
        String driverFile = config.getString(Keys.DATABASE_DRIVER_FILE);
        if (driverFile != null) {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            try {
                Method method = classLoader.getClass().getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                method.invoke((Object)classLoader, new File(driverFile).toURI().toURL());
            }
            catch (NoSuchMethodException e) {
                Method method = classLoader.getClass().getDeclaredMethod("appendToClassPathForInstrumentation", String.class);
                method.setAccessible(true);
                method.invoke((Object)classLoader, driverFile);
            }
        }
        if ((driver = config.getString(Keys.DATABASE_DRIVER)) != null) {
            Class.forName(driver);
        }
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName(driver);
        hikariConfig.setJdbcUrl(config.getString(Keys.DATABASE_URL));
        hikariConfig.setUsername(config.getString(Keys.DATABASE_USER));
        hikariConfig.setPassword(config.getString(Keys.DATABASE_PASSWORD));
        hikariConfig.setConnectionInitSql(config.getString(Keys.DATABASE_CHECK_CONNECTION));
        hikariConfig.setIdleTimeout(600000L);
        int maxPoolSize = config.getInteger(Keys.DATABASE_MAX_POOL_SIZE);
        if (maxPoolSize != 0) {
            hikariConfig.setMaximumPoolSize(maxPoolSize);
        }
        HikariDataSource dataSource = new HikariDataSource(hikariConfig);
        String changelog = config.getString(Keys.DATABASE_CHANGELOG);
        if (changelog != null && !changelog.isEmpty()) {
            DirectoryResourceAccessor resourceAccessor = new DirectoryResourceAccessor(new File("."));
            System.setProperty("liquibase.changelogLockWaitTimeInMinutes", "1");
            System.setProperty("liquibase.analytics.enabled", "false");
            try {
                Database database = DatabaseFactory.getInstance().openDatabase(config.getString(Keys.DATABASE_URL), config.getString(Keys.DATABASE_USER), config.getString(Keys.DATABASE_PASSWORD), config.getString(Keys.DATABASE_DRIVER), null, null, null, (ResourceAccessor)resourceAccessor);
                try (Liquibase liquibase = new Liquibase(changelog, (ResourceAccessor)resourceAccessor, database);){
                    liquibase.clearCheckSums();
                    liquibase.update(new Contexts());
                }
            }
            catch (LockException e) {
                throw new DatabaseLockException();
            }
        }
        return dataSource;
    }
}

