/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.etable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.swing.etable.ETable;
import org.netbeans.swing.etable.ETableColumn;
import org.netbeans.swing.etable.ETableColumnModel;

class ETableHeader
extends JTableHeader {
    public ETableHeader() {
    }

    public ETableHeader(TableColumnModel tableColumnModel) {
        super(tableColumnModel);
    }

    @Override
    public void setDefaultRenderer(TableCellRenderer tableCellRenderer) {
        super.setDefaultRenderer(new ETableHeaderRenderer(tableCellRenderer));
    }

    private static Icon mergeIcons(Icon icon, Icon icon2, int n, int n2, Component component) {
        int n3 = 0;
        int n4 = 0;
        if (icon != null) {
            n3 = icon.getIconWidth();
            n4 = icon.getIconHeight();
        }
        if (icon2 != null) {
            n3 = icon2.getIconWidth() + n > n3 ? icon2.getIconWidth() + n : n3;
            int n5 = n4 = icon2.getIconHeight() + n2 > n4 ? icon2.getIconHeight() + n2 : n4;
        }
        if (n3 < 1) {
            n3 = 16;
        }
        if (n4 < 1) {
            n4 = 16;
        }
        ColorModel colorModel = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(2);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(n3, n4), colorModel.isAlphaPremultiplied(), null);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (icon != null) {
            icon.paintIcon(component, graphics2D, 0, 0);
        }
        if (icon2 != null) {
            icon2.paintIcon(component, graphics2D, n, n2);
        }
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    private static class SortUpIcon
    implements Icon {
        @Override
        public int getIconWidth() {
            return 8;
        }

        @Override
        public int getIconHeight() {
            return 8;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(Color.BLACK);
            graphics.drawLine(n, n2 + 6, n + 8, n2 + 6);
            graphics.drawLine(n, n2 + 6, n + 4, n2 + 2);
            graphics.drawLine(n + 8, n2 + 6, n + 4, n2 + 2);
        }
    }

    private static class SortDownIcon
    implements Icon {
        @Override
        public int getIconWidth() {
            return 8;
        }

        @Override
        public int getIconHeight() {
            return 8;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(Color.BLACK);
            graphics.drawLine(n, n2 + 2, n + 8, n2 + 2);
            graphics.drawLine(n, n2 + 2, n + 4, n2 + 6);
            graphics.drawLine(n + 8, n2 + 2, n + 4, n2 + 6);
        }
    }

    private class ETableHeaderRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer,
    UIResource {
        private TableCellRenderer headerRendererUI;
        private Map<ETableColumn, TableCellRenderer> defaultColumnHeaderRenderers = new HashMap<ETableColumn, TableCellRenderer>();

        private ETableHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.headerRendererUI = tableCellRenderer;
            this.setName("TableHeader.renderer");
        }

        @Override
        public void updateUI() {
            TableCellRenderer tableCellRenderer = this.headerRendererUI;
            if (tableCellRenderer instanceof JComponent) {
                ((JComponent)((Object)tableCellRenderer)).updateUI();
            } else {
                super.updateUI();
            }
        }

        private TableCellRenderer getColumnHeaderRenderer(TableColumn tableColumn) {
            if (tableColumn instanceof ETableColumn) {
                TableCellRenderer tableCellRenderer;
                ETableColumn eTableColumn = (ETableColumn)tableColumn;
                if (!this.defaultColumnHeaderRenderers.containsKey(eTableColumn)) {
                    TableCellRenderer tableCellRenderer2 = eTableColumn.createDefaultHeaderRenderer();
                    if (tableCellRenderer2 instanceof ETableColumn.ETableColumnHeaderRendererDelegate) {
                        this.defaultColumnHeaderRenderers.put(eTableColumn, null);
                        tableCellRenderer = null;
                    } else {
                        eTableColumn.setTableHeaderRendererDelegate(this.headerRendererUI);
                        tableCellRenderer = tableCellRenderer2;
                    }
                } else {
                    tableCellRenderer = this.defaultColumnHeaderRenderers.get(eTableColumn);
                }
                if (tableCellRenderer != null) {
                    return tableCellRenderer;
                }
                return this.headerRendererUI;
            }
            return this.headerRendererUI;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            TableColumn tableColumn = ETableHeader.this.getColumnModel().getColumn(n2);
            TableCellRenderer tableCellRenderer = this.getColumnHeaderRenderer(tableColumn);
            Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof JLabel) {
                Object object2;
                JLabel jLabel = (JLabel)component;
                String string = "";
                if (object != null) {
                    string = object.toString();
                }
                if (jTable instanceof ETable) {
                    object2 = (ETable)jTable;
                    string = ((ETable)object2).getColumnDisplayName(string);
                }
                object2 = null;
                List<TableColumn> list = ((ETableColumnModel)jTable.getColumnModel()).getSortedColumns();
                int n3 = 0;
                boolean bl3 = false;
                Icon icon = null;
                if (tableColumn instanceof ETableColumn) {
                    ETableColumn eTableColumn = (ETableColumn)tableColumn;
                    n3 = eTableColumn.getSortRank();
                    bl3 = eTableColumn.isAscending();
                    icon = eTableColumn.getCustomIcon();
                }
                if (n3 != 0) {
                    if (list.size() > 1) {
                        string = string == null || string.isEmpty() ? Integer.toString(n3) : n3 + " " + string;
                    }
                    jLabel.setFont(jLabel.getFont().deriveFont(1));
                    if (bl3) {
                        object2 = UIManager.getIcon("ETableHeader.ascendingIcon");
                        if (object2 == null) {
                            object2 = new SortUpIcon();
                        }
                    } else {
                        object2 = UIManager.getIcon("ETableHeader.descendingIcon");
                        if (object2 == null) {
                            object2 = new SortDownIcon();
                        }
                    }
                }
                jLabel.setText(string);
                if (object2 == null) {
                    jLabel.setIcon(icon);
                } else if (icon == null) {
                    jLabel.setIcon((Icon)object2);
                } else {
                    jLabel.setIcon(ETableHeader.mergeIcons(icon, (Icon)object2, 16, 0, jLabel));
                }
            }
            return component;
        }
    }
}

