/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class CountingInputStream
extends FilterInputStream {
    public long count;
    public long mark;

    public CountingInputStream(InputStream inputStream) {
        inputStream.getClass();
        super(inputStream);
        this.mark = -1L;
    }

    @Override
    public final int read() {
        int n = this.in.read();
        if (n != -1) {
            ++this.count;
        }
        return n;
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 != -1) {
            this.count += (long)n3;
        }
        return n3;
    }

    @Override
    public final long skip(long l) {
        l = this.in.skip(l);
        this.count += l;
        return l;
    }

    @Override
    public final synchronized void mark(int n) {
        CountingInputStream countingInputStream = this;
        countingInputStream.in.mark(n);
        countingInputStream.mark = countingInputStream.count;
    }

    @Override
    public final synchronized void reset() {
        if (this.in.markSupported()) {
            if (this.mark != -1L) {
                CountingInputStream countingInputStream = this;
                countingInputStream.in.reset();
                countingInputStream.count = countingInputStream.mark;
                return;
            }
            throw new IOException("Mark not set");
        }
        throw new IOException("Mark not supported");
    }
}

