/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryDirectory {
    public static final String DIRECTORY_SEPARATOR = "/";
    private RepositoryDirectory parent;
    private ArrayList<RepositoryDirectory> children;
    private String directoryname;
    private long id;

    public RepositoryDirectory(RepositoryDirectory parent, String directoryname) {
        this.parent = parent;
        this.directoryname = directoryname;
        this.children = new ArrayList();
        this.id = 0L;
    }

    public RepositoryDirectory() {
        this(null, null);
    }

    public void clear() {
        this.parent = null;
        this.directoryname = null;
        this.children = new ArrayList();
        this.id = 0L;
    }

    public long getID() {
        return this.id;
    }

    public void setID(long id) {
        this.id = id;
    }

    public void setParent(RepositoryDirectory parent) {
        this.parent = parent;
    }

    public RepositoryDirectory getParent() {
        return this.parent;
    }

    public void setDirectoryName(String directoryname) {
        this.directoryname = directoryname;
    }

    public String getDirectoryName() {
        if (this.directoryname == null) {
            return DIRECTORY_SEPARATOR;
        }
        return this.directoryname;
    }

    public boolean isRoot() {
        return this.parent == null && this.directoryname == null;
    }

    public String getPath() {
        if (this.getParent() == null) {
            return DIRECTORY_SEPARATOR;
        }
        if (this.getParent().getParent() == null) {
            return DIRECTORY_SEPARATOR + this.getDirectoryName();
        }
        return this.getParent().getPath() + DIRECTORY_SEPARATOR + this.getDirectoryName();
    }

    public String[] getPathArray() {
        int depth = 1;
        RepositoryDirectory follow = this.getParent();
        if (follow != null) {
            ++depth;
            follow = follow.getParent();
        }
        String[] retval = new String[depth];
        int level = depth - 1;
        retval[level] = this.getDirectoryName();
        follow = this.getParent();
        if (follow != null) {
            retval[--level] = follow.getDirectoryName();
            follow = follow.getParent();
        }
        return retval;
    }

    public void addSubdirectory(RepositoryDirectory subdir) {
        subdir.setParent(this);
        this.children.add(subdir);
    }

    public int getNrSubdirectories() {
        return this.children.size();
    }

    public RepositoryDirectory getSubdirectory(int i) {
        if (this.children == null) {
            return null;
        }
        return this.children.get(i);
    }

    public RepositoryDirectory findDirectory(String[] path) {
        String[] directoryPath;
        if (this.isRoot() && path.length == 1 && path[0].equalsIgnoreCase(DIRECTORY_SEPARATOR)) {
            return this;
        }
        if (path.length < 1) {
            return this;
        }
        if (path.length > 0 && path[0].equalsIgnoreCase(DIRECTORY_SEPARATOR)) {
            directoryPath = new String[path.length - 1];
            for (int x = 0; x < directoryPath.length; ++x) {
                directoryPath[x] = path[x + 1];
            }
        } else {
            directoryPath = path;
        }
        if (this.isRoot() && directoryPath.length == 1 && directoryPath[0].equalsIgnoreCase(DIRECTORY_SEPARATOR)) {
            return this;
        }
        if (directoryPath.length == 1 && directoryPath[0].equalsIgnoreCase(this.getDirectoryName())) {
            return this;
        }
        if (directoryPath.length >= 1) {
            for (int i = 0; i < this.getNrSubdirectories(); ++i) {
                RepositoryDirectory subdir = this.getSubdirectory(i);
                if (!subdir.getDirectoryName().equalsIgnoreCase(directoryPath[0])) continue;
                if (directoryPath.length == 1) {
                    return subdir;
                }
                String[] subpath = new String[directoryPath.length - 1];
                for (int x = 0; x < subpath.length; ++x) {
                    subpath[x] = directoryPath[x + 1];
                }
                RepositoryDirectory look = subdir.findDirectory(subpath);
                if (look == null) continue;
                return look;
            }
        }
        return null;
    }

    public RepositoryDirectory findDirectory(String path) {
        String[] newPath = Const.splitPath((String)path, (String)DIRECTORY_SEPARATOR);
        String[] p = null;
        if (this.parent == null) {
            p = new String[newPath.length + 1];
            p[0] = DIRECTORY_SEPARATOR;
            for (int i = 0; i < newPath.length; ++i) {
                p[i + 1] = newPath[i];
            }
        } else {
            p = newPath;
        }
        return this.findDirectory(p);
    }

    public RepositoryDirectory findDirectory(long id_directory) {
        if (this.getID() == id_directory) {
            return this;
        }
        for (int i = 0; i < this.getNrSubdirectories(); ++i) {
            RepositoryDirectory rd = this.getSubdirectory(i).findDirectory(id_directory);
            if (rd == null) continue;
            return rd;
        }
        return null;
    }

    public String getXML() {
        return this.getXML(0);
    }

    public String getXML(int level) {
        String spaces = Const.rightPad((String)" ", (int)level);
        StringBuffer retval = new StringBuffer(200);
        retval.append(spaces).append("<repdir>").append(Const.CR);
        retval.append(spaces).append("  ").append(XMLHandler.addTagValue((String)"name", (String)this.getDirectoryName()));
        if (this.getNrSubdirectories() > 0) {
            retval.append(spaces).append("    <subdirs>").append(Const.CR);
            for (int i = 0; i < this.getNrSubdirectories(); ++i) {
                RepositoryDirectory subdir = this.getSubdirectory(i);
                retval.append(subdir.getXML(level + 1));
            }
            retval.append(spaces).append("    </subdirs>").append(Const.CR);
        }
        retval.append(spaces).append("</repdir>").append(Const.CR);
        return retval.toString();
    }

    public boolean loadXML(Node repdirnode) {
        try {
            this.clear();
            this.directoryname = XMLHandler.getTagValue((Node)repdirnode, (String)"name");
            Node subdirsnode = XMLHandler.getSubNode((Node)repdirnode, (String)"subdirs");
            if (subdirsnode != null) {
                int n = XMLHandler.countNodes((Node)subdirsnode, (String)"repdir");
                for (int i = 0; i < n; ++i) {
                    RepositoryDirectory subdir = new RepositoryDirectory();
                    Node subdirnode = XMLHandler.getSubNodeByNr((Node)subdirsnode, (String)"repdir", (int)i);
                    if (!subdir.loadXML(subdirnode)) {
                        return false;
                    }
                    subdir.setParent(this);
                    this.addSubdirectory(subdir);
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public RepositoryDirectory(Repository rep) throws KettleException {
        this.loadDirectoryTreeFromRepository(rep);
    }

    private void loadDirectoryTreeFromRepository(Repository rep) throws KettleException {
        try {
            this.clear();
            long[] subids = rep.getSubDirectoryIDs(this.getID());
            for (int i = 0; i < subids.length; ++i) {
                RepositoryDirectory subdir = new RepositoryDirectory();
                if (!subdir.loadRep(rep, subids[i])) continue;
                this.addSubdirectory(subdir);
            }
        }
        catch (Exception e) {
            throw new KettleException("An error occured loading the directory tree from the repository", (Throwable)e);
        }
    }

    public boolean loadRep(Repository rep, long id_directory) {
        try {
            RowMetaAndData row = rep.getDirectory(id_directory);
            if (row != null) {
                this.setID(id_directory);
                this.setDirectoryName(row.getString("DIRECTORY_NAME", null));
                long[] subids = rep.getSubDirectoryIDs(this.getID());
                for (int i = 0; i < subids.length; ++i) {
                    RepositoryDirectory subdir = new RepositoryDirectory();
                    if (!subdir.loadRep(rep, subids[i])) continue;
                    this.addSubdirectory(subdir);
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean addToRep(Repository rep) {
        try {
            long id_directory_parent = 0L;
            if (this.getParent() != null) {
                id_directory_parent = this.getParent().getID();
            }
            this.setID(rep.insertDirectory(id_directory_parent, this));
            LogWriter.getInstance().logDetailed(rep.getName(), "New id of directory = " + this.getID(), new Object[0]);
            rep.commit();
            this.findRoot().loadDirectoryTreeFromRepository(rep);
            return this.id > 0L;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void delFromRep(Repository rep) throws KettleException {
        try {
            String[] trans = rep.getTransformationNames(this.getID());
            String[] jobs = rep.getJobNames(this.getID());
            long[] subDirectories = rep.getSubDirectoryIDs(this.getID());
            if (trans.length != 0 || jobs.length != 0 || subDirectories.length != 0) {
                throw new KettleException("This directory is not empty!");
            }
            rep.deleteDirectory(this.getID());
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error deleting repository directory", (Throwable)e);
        }
    }

    public boolean renameInRep(Repository rep) {
        try {
            rep.renameDirectory(this.getID(), this.getDirectoryName());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public long[] getDirectoryIDs() {
        ArrayList<Long> ids = new ArrayList<Long>();
        this.getDirectoryIDs(ids);
        long[] retval = new long[ids.size()];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = (Long)ids.get(i);
        }
        return retval;
    }

    private void getDirectoryIDs(List<Long> ids) {
        Long lid = new Long(this.getID());
        ids.add(lid);
        for (int i = 0; i < this.getNrSubdirectories(); ++i) {
            this.getSubdirectory(i).getDirectoryIDs(ids);
        }
    }

    public RepositoryDirectory findRoot() {
        if (this.isRoot()) {
            return this;
        }
        return this.getParent().findRoot();
    }

    public RepositoryDirectory createDirectory(Repository rep, String directoryPath) throws KettleDatabaseException {
        String[] path = Const.splitPath((String)directoryPath, (String)DIRECTORY_SEPARATOR);
        RepositoryDirectory parent = this;
        for (int level = 1; level <= path.length; ++level) {
            String[] subPath = new String[level];
            for (int i = 0; i < level; ++i) {
                subPath[i] = path[i];
            }
            RepositoryDirectory rd = this.findDirectory(subPath);
            if (rd == null) {
                rd = new RepositoryDirectory(parent, subPath[level - 1]);
                System.out.println("New directory: [" + rd.getPath() + "]");
                if (rd.addToRep(rep)) {
                    parent.addSubdirectory(rd);
                    System.out.println("Created directory [" + rd.getPath() + "], id = " + rd.getID());
                    parent = rd;
                    continue;
                }
                throw new KettleDatabaseException("Unable to create repository directory [" + subPath[level - 1] + "] in directory [" + parent.getPath() + "]");
            }
            parent = rd;
        }
        return parent;
    }

    public String toString() {
        return this.getPath();
    }

    public String getPathObjectCombination(String transName) {
        if (this.isRoot()) {
            return this.getPath() + transName;
        }
        return this.getPath() + DIRECTORY_SEPARATOR + transName;
    }
}

