/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.append;

import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleRowException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.append.AppendData;
import org.pentaho.di.trans.steps.append.AppendMeta;
import org.pentaho.di.trans.steps.append.Messages;

public class Append
extends BaseStep
implements StepInterface {
    private AppendMeta meta;
    private AppendData data;

    public Append(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (AppendMeta)smi;
        this.data = (AppendData)sdi;
        Object[] input = null;
        if (this.data.processHead) {
            input = this.getRowFrom(this.data.headRowSet);
            if (input == null) {
                this.data.processHead = false;
                this.data.processTail = true;
            } else if (this.data.outputRowMeta == null) {
                this.data.outputRowMeta = this.data.headRowSet.getRowMeta();
            }
        }
        if (this.data.processTail) {
            input = this.getRowFrom(this.data.tailRowSet);
            if (input == null) {
                this.setOutputDone();
                return false;
            }
            if (this.data.outputRowMeta == null) {
                this.data.outputRowMeta = this.data.tailRowSet.getRowMeta();
            }
            if (this.data.firstTail) {
                this.data.firstTail = false;
                try {
                    this.checkInputLayoutValid(this.data.headRowSet.getRowMeta(), this.data.tailRowSet.getRowMeta());
                }
                catch (KettleRowException e) {
                    throw new KettleException(Messages.getString("Append.Exception.InvalidLayoutDetected"), (Throwable)e);
                }
            }
        }
        if (input != null) {
            this.putRow(this.data.outputRowMeta, input);
        }
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(Messages.getString("AppendRows.LineNumber") + this.getLinesRead());
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (AppendMeta)smi;
        this.data = (AppendData)sdi;
        if (super.init(smi, sdi)) {
            this.data.processHead = true;
            this.data.processTail = false;
            this.data.firstTail = true;
            if (this.meta.getHeadStepName() == null || this.meta.getTailStepName() == null) {
                this.logError(Messages.getString("AppendRows.Log.BothHopsAreNeeded"));
            } else {
                try {
                    this.data.headRowSet = this.findInputRowSet(this.meta.getHeadStepName());
                    this.data.tailRowSet = this.findInputRowSet(this.meta.getTailStepName());
                    return true;
                }
                catch (Exception e) {
                    this.log.logError(this.toString(), e.getMessage(), new Object[0]);
                    return false;
                }
            }
        }
        return false;
    }

    protected void checkInputLayoutValid(RowMetaInterface referenceRowMeta, RowMetaInterface compareRowMeta) throws KettleRowException {
        if (referenceRowMeta != null && compareRowMeta != null) {
            BaseStep.safeModeChecking(referenceRowMeta, compareRowMeta);
        }
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

