/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.security.Key;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.test.dsig.TestUtils;
import junit.framework.TestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLSignContextTest
extends TestCase {
    private XMLSignContext defContext;
    private Key[] KEYS;
    private Document doc;

    public XMLSignContextTest() {
        super("XMLSignContextTest");
    }

    public XMLSignContextTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        this.KEYS = new Key[3];
        this.KEYS[0] = TestUtils.getPrivateKey("DSA");
        this.KEYS[1] = TestUtils.getPrivateKey("RSA");
        this.KEYS[2] = new SecretKeySpec(new byte[16], "HmacSHA1");
        SecretKeySpec secretKeySpec = new SecretKeySpec(new byte[8], "DES");
        this.doc = TestUtils.newDocument();
        this.defContext = new DOMSignContext(secretKeySpec, (Node)this.doc);
    }

    public void tearDown() {
    }

    public void testsetngetBaseURI() throws Exception {
        XMLSignContextTest.assertNull((Object)this.defContext.getBaseURI());
        String string = "http://www.w3.org/2000/09/xmldsig#";
        this.defContext.setBaseURI(string);
        XMLSignContextTest.assertEquals((String)this.defContext.getBaseURI(), (String)string);
        this.defContext.setBaseURI(null);
        XMLSignContextTest.assertNull((Object)this.defContext.getBaseURI());
    }

    public void testsetngetProperty() throws Exception {
        String string = "key";
        XMLSignContextTest.assertNull((Object)this.defContext.getProperty(string));
        try {
            this.defContext.setProperty(null, null);
            XMLSignContextTest.fail((String)"Should raise a NPE with a null name");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            XMLSignContextTest.fail((String)("Should raise a NPE instead of " + exception));
        }
        String string2 = "value#1";
        String string3 = "value#2";
        XMLSignContextTest.assertNull((Object)this.defContext.setProperty(string, string2));
        XMLSignContextTest.assertEquals((Object)this.defContext.getProperty(string), (Object)string2);
        XMLSignContextTest.assertEquals((Object)this.defContext.setProperty(string, string3), (Object)string2);
        XMLSignContextTest.assertEquals((Object)this.defContext.getProperty(string), (Object)string3);
        XMLSignContextTest.assertEquals((Object)this.defContext.setProperty(string, null), (Object)string3);
        XMLSignContextTest.assertNull((Object)this.defContext.getProperty(string));
    }

    public void testsetngetURIDereferencer() throws Exception {
        XMLSignContextTest.assertNull((Object)this.defContext.getURIDereferencer());
        byte[] byArray = "simpleDereferencer".getBytes();
        TestUtils.OctetStreamURIDereferencer octetStreamURIDereferencer = new TestUtils.OctetStreamURIDereferencer(byArray);
        this.defContext.setURIDereferencer(octetStreamURIDereferencer);
        XMLSignContextTest.assertEquals((Object)this.defContext.getURIDereferencer(), (Object)octetStreamURIDereferencer);
        this.defContext.setURIDereferencer(null);
        XMLSignContextTest.assertNull((Object)this.defContext.getURIDereferencer());
    }

    public void testsetngetKeySelector() throws Exception {
        this.defContext.setKeySelector(null);
        XMLSignContextTest.assertNull((Object)this.defContext.getKeySelector());
        KeySelector keySelector = KeySelector.singletonKeySelector(this.KEYS[0]);
        this.defContext.setKeySelector(keySelector);
        XMLSignContextTest.assertEquals((Object)this.defContext.getKeySelector(), (Object)keySelector);
    }
}

