/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.av1;

import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtp.codec.av1.Av1DDPacket;
import org.jitsi.nlj.rtp.codec.av1.Av1DDPacketKt;
import org.jitsi.rtp.rtp.header_extensions.Av1DependencyDescriptorHeaderExtension;
import org.jitsi.rtp.rtp.header_extensions.Av1DependencyDescriptorHeaderExtensionKt;
import org.jitsi.rtp.rtp.header_extensions.Av1TemplateDependencyStructure;
import org.jitsi.rtp.rtp.header_extensions.DTI;
import org.jitsi.rtp.rtp.header_extensions.FrameInfo;
import org.jitsi.rtp.util.RtpUtils;
import org.jitsi.rtp.util.RtpUtilsKt;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;
import org.jitsi.videobridge.cc.av1.Av1DDFrame;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 82\u00020\u0001:\u00018B_\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\b\u0010\r\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013B=\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0012\u0010\u0015J\u000e\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\nJ\u000e\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\nJ\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/J\u000e\u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u00020/J\u0006\u00106\u001a\u00020-J\r\u00107\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR\u0015\u0010\r\u001a\u0004\u0018\u00010\n\u00a2\u0006\n\n\u0002\u0010 \u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001e\u0010&\u001a\u00020\n2\u0006\u0010%\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001cR\u0011\u00102\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u001cR\u0011\u00104\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u001c\u00a8\u00069"}, d2={"Lorg/jitsi/videobridge/cc/av1/Av1DDFrameProjection;", "", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "av1Frame", "Lorg/jitsi/videobridge/cc/av1/Av1DDFrame;", "ssrc", "", "timestamp", "sequenceNumberDelta", "", "frameNumber", "templateIdDelta", "dti", "mark", "", "created", "Ljava/time/Instant;", "<init>", "(Lorg/jitsi/utils/logging/DiagnosticContext;Lorg/jitsi/videobridge/cc/av1/Av1DDFrame;JJIIILjava/lang/Integer;ZLjava/time/Instant;)V", "templateId", "(Lorg/jitsi/utils/logging/DiagnosticContext;JIJLjava/lang/Integer;Ljava/lang/Integer;)V", "getAv1Frame", "()Lorg/jitsi/videobridge/cc/av1/Av1DDFrame;", "getSsrc", "()J", "getTimestamp", "getFrameNumber", "()I", "getTemplateIdDelta", "getDti", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getMark", "()Z", "getCreated", "()Ljava/time/Instant;", "value", "closedSeq", "getClosedSeq", "rewriteSeqNo", "seq", "rewriteTemplateId", "id", "rewriteRtp", "", "pkt", "Lorg/jitsi/nlj/rtp/codec/av1/Av1DDPacket;", "accept", "rtpPacket", "earliestProjectedSeqNum", "getEarliestProjectedSeqNum", "latestProjectedSeqNum", "getLatestProjectedSeqNum", "close", "getNextTemplateId", "Companion", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nAv1DDFrameProjection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Av1DDFrameProjection.kt\norg/jitsi/videobridge/cc/av1/Av1DDFrameProjection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,247:1\n1#2:248\n*E\n"})
public final class Av1DDFrameProjection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DiagnosticContext diagnosticContext;
    @Nullable
    private final Av1DDFrame av1Frame;
    private final long ssrc;
    private final long timestamp;
    private final int sequenceNumberDelta;
    private final int frameNumber;
    private final int templateIdDelta;
    @Nullable
    private final Integer dti;
    private final boolean mark;
    @Nullable
    private final Instant created;
    private int closedSeq;
    private static final TimeSeriesLogger timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(Av1DDFrameProjection.class);

    public Av1DDFrameProjection(@NotNull DiagnosticContext diagnosticContext, @Nullable Av1DDFrame av1Frame, long ssrc, long timestamp, int sequenceNumberDelta, int frameNumber, int templateIdDelta, @Nullable Integer dti, boolean mark, @Nullable Instant created) {
        Intrinsics.checkNotNullParameter(diagnosticContext, "diagnosticContext");
        this.diagnosticContext = diagnosticContext;
        this.av1Frame = av1Frame;
        this.ssrc = ssrc;
        this.timestamp = timestamp;
        this.sequenceNumberDelta = sequenceNumberDelta;
        this.frameNumber = frameNumber;
        this.templateIdDelta = templateIdDelta;
        this.dti = dti;
        this.mark = mark;
        this.created = created;
        this.closedSeq = -1;
    }

    @Nullable
    public final Av1DDFrame getAv1Frame() {
        return this.av1Frame;
    }

    public final long getSsrc() {
        return this.ssrc;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final int getFrameNumber() {
        return this.frameNumber;
    }

    public final int getTemplateIdDelta() {
        return this.templateIdDelta;
    }

    @Nullable
    public final Integer getDti() {
        return this.dti;
    }

    public final boolean getMark() {
        return this.mark;
    }

    @Nullable
    public final Instant getCreated() {
        return this.created;
    }

    public final int getClosedSeq() {
        return this.closedSeq;
    }

    public Av1DDFrameProjection(@NotNull DiagnosticContext diagnosticContext, long ssrc, int sequenceNumberDelta, long timestamp, @Nullable Integer frameNumber, @Nullable Integer templateId) {
        Intrinsics.checkNotNullParameter(diagnosticContext, "diagnosticContext");
        Integer n = frameNumber;
        Integer n2 = templateId;
        this(diagnosticContext, null, ssrc, timestamp, sequenceNumberDelta, n != null ? n : 0, n2 != null ? n2 : -1, null, false, null);
    }

    public final int rewriteSeqNo(int seq) {
        return RtpUtils.Companion.applySequenceNumberDelta(seq, this.sequenceNumberDelta);
    }

    public final int rewriteTemplateId(int id) {
        return Av1DDPacketKt.applyTemplateIdDelta(id, this.templateIdDelta);
    }

    public final void rewriteRtp(@NotNull Av1DDPacket pkt) {
        block7: {
            Av1DependencyDescriptorHeaderExtension descriptor2;
            block8: {
                block9: {
                    Intrinsics.checkNotNullParameter(pkt, "pkt");
                    int sequenceNumber = this.rewriteSeqNo(pkt.getSequenceNumber());
                    int templateId = this.rewriteTemplateId(pkt.getStatelessDescriptor().getFrameDependencyTemplateId());
                    if (timeSeriesLogger.isTraceEnabled()) {
                        DiagnosticContext.TimeSeriesPoint timeSeriesPoint = this.diagnosticContext.makeTimeSeriesPoint("rtp_av1_rewrite").addField("orig.rtp.ssrc", pkt.getSsrc()).addField("orig.rtp.timestamp", pkt.getTimestamp()).addField("orig.rtp.seq", pkt.getSequenceNumber()).addField("orig.av1.framenum", pkt.getFrameNumber());
                        Object object = pkt.getFrameInfo();
                        if (object == null || (object = ((FrameInfo)object).getDti()) == null || (object = Av1DependencyDescriptorHeaderExtensionKt.toShortString((List<? extends DTI>)object)) == null) {
                            object = "-";
                        }
                        Integer n = this.dti;
                        timeSeriesLogger.trace(timeSeriesPoint.addField("orig.av1.dti", object).addField("orig.av1.templateid", pkt.getStatelessDescriptor().getFrameDependencyTemplateId()).addField("proj.rtp.ssrc", this.ssrc).addField("proj.rtp.timestamp", this.timestamp).addField("proj.rtp.seq", sequenceNumber).addField("proj.av1.framenum", this.frameNumber).addField("proj.av1.dti", n != null ? n : -1).addField("proj.av1.templateid", templateId).addField("proj.rtp.mark", this.mark));
                    }
                    pkt.setSsrc(this.ssrc);
                    pkt.setTimestamp(this.timestamp);
                    pkt.setSequenceNumber(sequenceNumber);
                    if (this.mark && pkt.isEndOfFrame()) {
                        pkt.setMarked(true);
                    }
                    if ((descriptor2 = pkt.getDescriptor()) == null || this.frameNumber == pkt.getFrameNumber() && templateId == descriptor2.getFrameDependencyTemplateId() && this.dti == null) break block7;
                    descriptor2.setFrameNumber(this.frameNumber);
                    descriptor2.setFrameDependencyTemplateId(templateId);
                    Av1TemplateDependencyStructure structure = descriptor2.getStructure();
                    if (!(descriptor2.getNewTemplateDependencyStructure() == null || descriptor2.getNewTemplateDependencyStructure() == descriptor2.getStructure())) {
                        String string = "Check failed.";
                        throw new IllegalStateException(string.toString());
                    }
                    structure.setTemplateIdOffset(this.rewriteTemplateId(structure.getTemplateIdOffset()));
                    if (this.dti == null) break block8;
                    if (descriptor2.getNewTemplateDependencyStructure() == null) break block9;
                    Integer n = this.dti;
                    int n2 = (1 << structure.getDecodeTargetCount()) - 1;
                    if (n != null && n == n2) break block8;
                }
                descriptor2.setActiveDecodeTargetsBitmask(this.dti);
            }
            pkt.setDescriptor(descriptor2);
            pkt.reencodeDdExt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean accept(@NotNull Av1DDPacket rtpPacket) {
        Intrinsics.checkNotNullParameter(rtpPacket, "rtpPacket");
        Av1DDFrame av1DDFrame = this.av1Frame;
        if (!(av1DDFrame != null ? av1DDFrame.matchesFrame(rtpPacket) : false)) {
            return false;
        }
        Av1DDFrame av1DDFrame2 = this.av1Frame;
        synchronized (av1DDFrame2) {
            boolean bl = false;
            boolean bl2 = this.closedSeq < 0 ? true : RtpUtilsKt.isOlderThan(rtpPacket.getSequenceNumber(), this.closedSeq);
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getEarliestProjectedSeqNum() {
        if (this.av1Frame == null) {
            return this.sequenceNumberDelta;
        }
        Av1DDFrame av1DDFrame = this.av1Frame;
        synchronized (av1DDFrame) {
            boolean bl = false;
            int n = this.rewriteSeqNo(this.av1Frame.getEarliestKnownSequenceNumber());
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getLatestProjectedSeqNum() {
        if (this.av1Frame == null) {
            return this.sequenceNumberDelta;
        }
        Av1DDFrame av1DDFrame = this.av1Frame;
        synchronized (av1DDFrame) {
            boolean bl = false;
            int n = this.rewriteSeqNo(this.av1Frame.getLatestKnownSequenceNumber());
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        if (this.av1Frame != null) {
            Av1DDFrame av1DDFrame = this.av1Frame;
            synchronized (av1DDFrame) {
                boolean bl = false;
                this.closedSeq = this.av1Frame.getLatestKnownSequenceNumber();
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Nullable
    public final Integer getNextTemplateId() {
        Integer n;
        if (this.av1Frame == null && this.templateIdDelta != -1) {
            return this.templateIdDelta;
        }
        Object object = this.av1Frame;
        if (object != null && (object = ((Av1DDFrame)object).getStructure()) != null) {
            Object it = object;
            boolean bl = false;
            n = this.rewriteTemplateId(((Av1TemplateDependencyStructure)it).getTemplateIdOffset() + ((Av1TemplateDependencyStructure)it).getTemplateCount());
        } else {
            n = null;
        }
        return n;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jitsi/videobridge/cc/av1/Av1DDFrameProjection$Companion;", "", "<init>", "()V", "timeSeriesLogger", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "kotlin.jvm.PlatformType", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

