/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.RadiotapPacket;
import org.pcap4j.util.ByteArrays;

public final class RadiotapDataFlags
implements RadiotapPacket.RadiotapData {
    private static final long serialVersionUID = 3144457914168529098L;
    private static final int LENGTH = 1;
    private final boolean cfp;
    private final boolean shortPreamble;
    private final boolean wepEncrypted;
    private final boolean fragmented;
    private final boolean includingFcs;
    private final boolean padding;
    private final boolean badFcs;
    private final boolean shortGuardInterval;

    public static RadiotapDataFlags newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new RadiotapDataFlags(rawData, offset, length);
    }

    private RadiotapDataFlags(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 1) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build a RadiotapFlags (").append(1).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.cfp = (rawData[offset] & 1) != 0;
        this.shortPreamble = (rawData[offset] & 2) != 0;
        this.wepEncrypted = (rawData[offset] & 4) != 0;
        this.fragmented = (rawData[offset] & 8) != 0;
        this.includingFcs = (rawData[offset] & 0x10) != 0;
        this.padding = (rawData[offset] & 0x20) != 0;
        this.badFcs = (rawData[offset] & 0x40) != 0;
        this.shortGuardInterval = (rawData[offset] & 0x80) != 0;
    }

    private RadiotapDataFlags(Builder builder2) {
        if (builder2 == null) {
            throw new NullPointerException("builder is null.");
        }
        this.cfp = builder2.cfp;
        this.shortPreamble = builder2.shortPreamble;
        this.wepEncrypted = builder2.wepEncrypted;
        this.fragmented = builder2.fragmented;
        this.includingFcs = builder2.includingFcs;
        this.padding = builder2.padding;
        this.badFcs = builder2.badFcs;
        this.shortGuardInterval = builder2.shortGuardInterval;
    }

    public boolean isCfp() {
        return this.cfp;
    }

    public boolean isShortPreamble() {
        return this.shortPreamble;
    }

    public boolean isWepEncrypted() {
        return this.wepEncrypted;
    }

    public boolean isFragmented() {
        return this.fragmented;
    }

    public boolean isIncludingFcs() {
        return this.includingFcs;
    }

    public boolean hasPadding() {
        return this.padding;
    }

    public boolean isBadFcs() {
        return this.badFcs;
    }

    public boolean isShortGuardInterval() {
        return this.shortGuardInterval;
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public byte[] getRawData() {
        byte[] data = new byte[1];
        if (this.cfp) {
            data[0] = (byte)(data[0] | 1);
        }
        if (this.shortPreamble) {
            data[0] = (byte)(data[0] | 2);
        }
        if (this.wepEncrypted) {
            data[0] = (byte)(data[0] | 4);
        }
        if (this.fragmented) {
            data[0] = (byte)(data[0] | 8);
        }
        if (this.includingFcs) {
            data[0] = (byte)(data[0] | 0x10);
        }
        if (this.padding) {
            data[0] = (byte)(data[0] | 0x20);
        }
        if (this.badFcs) {
            data[0] = (byte)(data[0] | 0x40);
        }
        if (this.shortGuardInterval) {
            data[0] = (byte)(data[0] | 0x80);
        }
        return data;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("Flags: ").append(ls).append(indent).append("  CFP: ").append(this.cfp).append(ls).append(indent).append("  Short Preamble: ").append(this.shortPreamble).append(ls).append(indent).append("  WEP: ").append(this.wepEncrypted).append(ls).append(indent).append("  Fragmented: ").append(this.fragmented).append(ls).append(indent).append("  FCS: ").append(this.includingFcs).append(ls).append(indent).append("  PAD: ").append(this.padding).append(ls).append(indent).append("  Bad FCS: ").append(this.badFcs).append(ls).append(indent).append("  Short Guard Interval: ").append(this.shortGuardInterval).append(ls);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.badFcs ? 1231 : 1237);
        result = 31 * result + (this.cfp ? 1231 : 1237);
        result = 31 * result + (this.fragmented ? 1231 : 1237);
        result = 31 * result + (this.includingFcs ? 1231 : 1237);
        result = 31 * result + (this.padding ? 1231 : 1237);
        result = 31 * result + (this.shortGuardInterval ? 1231 : 1237);
        result = 31 * result + (this.shortPreamble ? 1231 : 1237);
        result = 31 * result + (this.wepEncrypted ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RadiotapDataFlags other = (RadiotapDataFlags)obj;
        if (this.badFcs != other.badFcs) {
            return false;
        }
        if (this.cfp != other.cfp) {
            return false;
        }
        if (this.fragmented != other.fragmented) {
            return false;
        }
        if (this.includingFcs != other.includingFcs) {
            return false;
        }
        if (this.padding != other.padding) {
            return false;
        }
        if (this.shortGuardInterval != other.shortGuardInterval) {
            return false;
        }
        if (this.shortPreamble != other.shortPreamble) {
            return false;
        }
        return this.wepEncrypted == other.wepEncrypted;
    }

    public static final class Builder {
        private boolean cfp;
        private boolean shortPreamble;
        private boolean wepEncrypted;
        private boolean fragmented;
        private boolean includingFcs;
        private boolean padding;
        private boolean badFcs;
        private boolean shortGuardInterval;

        public Builder() {
        }

        private Builder(RadiotapDataFlags obj) {
            this.cfp = obj.cfp;
        }

        public Builder cfp(boolean cfp) {
            this.cfp = cfp;
            return this;
        }

        public Builder shortPreamble(boolean shortPreamble) {
            this.shortPreamble = shortPreamble;
            return this;
        }

        public Builder wepEncrypted(boolean wepEncrypted) {
            this.wepEncrypted = wepEncrypted;
            return this;
        }

        public Builder fragmented(boolean fragmented) {
            this.fragmented = fragmented;
            return this;
        }

        public Builder includingFcs(boolean includingFcs) {
            this.includingFcs = includingFcs;
            return this;
        }

        public Builder padding(boolean padding) {
            this.padding = padding;
            return this;
        }

        public Builder badFcs(boolean badFcs) {
            this.badFcs = badFcs;
            return this;
        }

        public Builder shortGuardInterval(boolean shortGuardInterval) {
            this.shortGuardInterval = shortGuardInterval;
            return this;
        }

        public RadiotapDataFlags build() {
            return new RadiotapDataFlags(this);
        }
    }
}

