/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrAction;
import org.lwjgl.openxr.XrBindingModificationBaseHeaderKHR;
import org.lwjgl.openxr.XrHapticBaseHeader;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrInteractionProfileAnalogThresholdVALVE
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int ACTION;
    public static final int BINDING;
    public static final int ONTHRESHOLD;
    public static final int OFFTHRESHOLD;
    public static final int ONHAPTIC;
    public static final int OFFHAPTIC;

    public XrInteractionProfileAnalogThresholdVALVE(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrInteractionProfileAnalogThresholdVALVE.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrInteractionProfileAnalogThresholdVALVE.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrInteractionProfileAnalogThresholdVALVE.nnext(this.address());
    }

    @NativeType(value="XrAction")
    public long action() {
        return XrInteractionProfileAnalogThresholdVALVE.naction(this.address());
    }

    @NativeType(value="XrPath")
    public long binding() {
        return XrInteractionProfileAnalogThresholdVALVE.nbinding(this.address());
    }

    public float onThreshold() {
        return XrInteractionProfileAnalogThresholdVALVE.nonThreshold(this.address());
    }

    public float offThreshold() {
        return XrInteractionProfileAnalogThresholdVALVE.noffThreshold(this.address());
    }

    @Nullable
    @NativeType(value="XrHapticBaseHeader const *")
    public XrHapticBaseHeader onHaptic() {
        return XrInteractionProfileAnalogThresholdVALVE.nonHaptic(this.address());
    }

    @Nullable
    @NativeType(value="XrHapticBaseHeader const *")
    public XrHapticBaseHeader offHaptic() {
        return XrInteractionProfileAnalogThresholdVALVE.noffHaptic(this.address());
    }

    public XrInteractionProfileAnalogThresholdVALVE type(@NativeType(value="XrStructureType") int value) {
        XrInteractionProfileAnalogThresholdVALVE.ntype(this.address(), value);
        return this;
    }

    public XrInteractionProfileAnalogThresholdVALVE type$Default() {
        return this.type(1000079000);
    }

    public XrInteractionProfileAnalogThresholdVALVE next(@NativeType(value="void const *") long value) {
        XrInteractionProfileAnalogThresholdVALVE.nnext(this.address(), value);
        return this;
    }

    public XrInteractionProfileAnalogThresholdVALVE action(XrAction value) {
        XrInteractionProfileAnalogThresholdVALVE.naction(this.address(), value);
        return this;
    }

    public XrInteractionProfileAnalogThresholdVALVE binding(@NativeType(value="XrPath") long value) {
        XrInteractionProfileAnalogThresholdVALVE.nbinding(this.address(), value);
        return this;
    }

    public XrInteractionProfileAnalogThresholdVALVE onThreshold(float value) {
        XrInteractionProfileAnalogThresholdVALVE.nonThreshold(this.address(), value);
        return this;
    }

    public XrInteractionProfileAnalogThresholdVALVE offThreshold(float value) {
        XrInteractionProfileAnalogThresholdVALVE.noffThreshold(this.address(), value);
        return this;
    }

    public XrInteractionProfileAnalogThresholdVALVE onHaptic(@Nullable @NativeType(value="XrHapticBaseHeader const *") XrHapticBaseHeader value) {
        XrInteractionProfileAnalogThresholdVALVE.nonHaptic(this.address(), value);
        return this;
    }

    public XrInteractionProfileAnalogThresholdVALVE offHaptic(@Nullable @NativeType(value="XrHapticBaseHeader const *") XrHapticBaseHeader value) {
        XrInteractionProfileAnalogThresholdVALVE.noffHaptic(this.address(), value);
        return this;
    }

    public XrInteractionProfileAnalogThresholdVALVE set(int type, long next, XrAction action, long binding, float onThreshold, float offThreshold, @Nullable XrHapticBaseHeader onHaptic, @Nullable XrHapticBaseHeader offHaptic) {
        this.type(type);
        this.next(next);
        this.action(action);
        this.binding(binding);
        this.onThreshold(onThreshold);
        this.offThreshold(offThreshold);
        this.onHaptic(onHaptic);
        this.offHaptic(offHaptic);
        return this;
    }

    public XrInteractionProfileAnalogThresholdVALVE set(XrInteractionProfileAnalogThresholdVALVE src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrInteractionProfileAnalogThresholdVALVE malloc() {
        return (XrInteractionProfileAnalogThresholdVALVE)XrInteractionProfileAnalogThresholdVALVE.wrap(XrInteractionProfileAnalogThresholdVALVE.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrInteractionProfileAnalogThresholdVALVE calloc() {
        return (XrInteractionProfileAnalogThresholdVALVE)XrInteractionProfileAnalogThresholdVALVE.wrap(XrInteractionProfileAnalogThresholdVALVE.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrInteractionProfileAnalogThresholdVALVE create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrInteractionProfileAnalogThresholdVALVE)XrInteractionProfileAnalogThresholdVALVE.wrap(XrInteractionProfileAnalogThresholdVALVE.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrInteractionProfileAnalogThresholdVALVE create(long address) {
        return (XrInteractionProfileAnalogThresholdVALVE)XrInteractionProfileAnalogThresholdVALVE.wrap(XrInteractionProfileAnalogThresholdVALVE.class, (long)address);
    }

    @Nullable
    public static XrInteractionProfileAnalogThresholdVALVE createSafe(long address) {
        return address == 0L ? null : (XrInteractionProfileAnalogThresholdVALVE)XrInteractionProfileAnalogThresholdVALVE.wrap(XrInteractionProfileAnalogThresholdVALVE.class, (long)address);
    }

    public static XrInteractionProfileAnalogThresholdVALVE create(XrBindingModificationBaseHeaderKHR value) {
        return (XrInteractionProfileAnalogThresholdVALVE)XrInteractionProfileAnalogThresholdVALVE.wrap(XrInteractionProfileAnalogThresholdVALVE.class, (Struct)value);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrInteractionProfileAnalogThresholdVALVE.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrInteractionProfileAnalogThresholdVALVE.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrInteractionProfileAnalogThresholdVALVE.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrInteractionProfileAnalogThresholdVALVE.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrInteractionProfileAnalogThresholdVALVE.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrInteractionProfileAnalogThresholdVALVE.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrInteractionProfileAnalogThresholdVALVE.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static Buffer create(XrBindingModificationBaseHeaderKHR.Buffer value) {
        return (Buffer)XrInteractionProfileAnalogThresholdVALVE.wrap(Buffer.class, (CustomBuffer)value);
    }

    public static XrInteractionProfileAnalogThresholdVALVE malloc(MemoryStack stack) {
        return (XrInteractionProfileAnalogThresholdVALVE)XrInteractionProfileAnalogThresholdVALVE.wrap(XrInteractionProfileAnalogThresholdVALVE.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrInteractionProfileAnalogThresholdVALVE calloc(MemoryStack stack) {
        return (XrInteractionProfileAnalogThresholdVALVE)XrInteractionProfileAnalogThresholdVALVE.wrap(XrInteractionProfileAnalogThresholdVALVE.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrInteractionProfileAnalogThresholdVALVE.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrInteractionProfileAnalogThresholdVALVE.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long naction(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)ACTION));
    }

    public static long nbinding(long struct) {
        return UNSAFE.getLong(null, struct + (long)BINDING);
    }

    public static float nonThreshold(long struct) {
        return UNSAFE.getFloat(null, struct + (long)ONTHRESHOLD);
    }

    public static float noffThreshold(long struct) {
        return UNSAFE.getFloat(null, struct + (long)OFFTHRESHOLD);
    }

    @Nullable
    public static XrHapticBaseHeader nonHaptic(long struct) {
        return XrHapticBaseHeader.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)ONHAPTIC)));
    }

    @Nullable
    public static XrHapticBaseHeader noffHaptic(long struct) {
        return XrHapticBaseHeader.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)OFFHAPTIC)));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void naction(long struct, XrAction value) {
        MemoryUtil.memPutAddress((long)(struct + (long)ACTION), (long)value.address());
    }

    public static void nbinding(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)BINDING, value);
    }

    public static void nonThreshold(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)ONTHRESHOLD, value);
    }

    public static void noffThreshold(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)OFFTHRESHOLD, value);
    }

    public static void nonHaptic(long struct, @Nullable XrHapticBaseHeader value) {
        MemoryUtil.memPutAddress((long)(struct + (long)ONHAPTIC), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void noffHaptic(long struct, @Nullable XrHapticBaseHeader value) {
        MemoryUtil.memPutAddress((long)(struct + (long)OFFHAPTIC), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)ACTION)));
    }

    static {
        Struct.Layout layout = XrInteractionProfileAnalogThresholdVALVE.__struct((Struct.Member[])new Struct.Member[]{XrInteractionProfileAnalogThresholdVALVE.__member((int)4), XrInteractionProfileAnalogThresholdVALVE.__member((int)POINTER_SIZE), XrInteractionProfileAnalogThresholdVALVE.__member((int)POINTER_SIZE), XrInteractionProfileAnalogThresholdVALVE.__member((int)8), XrInteractionProfileAnalogThresholdVALVE.__member((int)4), XrInteractionProfileAnalogThresholdVALVE.__member((int)4), XrInteractionProfileAnalogThresholdVALVE.__member((int)POINTER_SIZE), XrInteractionProfileAnalogThresholdVALVE.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        ACTION = layout.offsetof(2);
        BINDING = layout.offsetof(3);
        ONTHRESHOLD = layout.offsetof(4);
        OFFTHRESHOLD = layout.offsetof(5);
        ONHAPTIC = layout.offsetof(6);
        OFFHAPTIC = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<XrInteractionProfileAnalogThresholdVALVE, Buffer>
    implements NativeResource {
        private static final XrInteractionProfileAnalogThresholdVALVE ELEMENT_FACTORY = XrInteractionProfileAnalogThresholdVALVE.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrInteractionProfileAnalogThresholdVALVE getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrInteractionProfileAnalogThresholdVALVE.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrInteractionProfileAnalogThresholdVALVE.nnext(this.address());
        }

        @NativeType(value="XrAction")
        public long action() {
            return XrInteractionProfileAnalogThresholdVALVE.naction(this.address());
        }

        @NativeType(value="XrPath")
        public long binding() {
            return XrInteractionProfileAnalogThresholdVALVE.nbinding(this.address());
        }

        public float onThreshold() {
            return XrInteractionProfileAnalogThresholdVALVE.nonThreshold(this.address());
        }

        public float offThreshold() {
            return XrInteractionProfileAnalogThresholdVALVE.noffThreshold(this.address());
        }

        @Nullable
        @NativeType(value="XrHapticBaseHeader const *")
        public XrHapticBaseHeader onHaptic() {
            return XrInteractionProfileAnalogThresholdVALVE.nonHaptic(this.address());
        }

        @Nullable
        @NativeType(value="XrHapticBaseHeader const *")
        public XrHapticBaseHeader offHaptic() {
            return XrInteractionProfileAnalogThresholdVALVE.noffHaptic(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrInteractionProfileAnalogThresholdVALVE.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000079000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrInteractionProfileAnalogThresholdVALVE.nnext(this.address(), value);
            return this;
        }

        public Buffer action(XrAction value) {
            XrInteractionProfileAnalogThresholdVALVE.naction(this.address(), value);
            return this;
        }

        public Buffer binding(@NativeType(value="XrPath") long value) {
            XrInteractionProfileAnalogThresholdVALVE.nbinding(this.address(), value);
            return this;
        }

        public Buffer onThreshold(float value) {
            XrInteractionProfileAnalogThresholdVALVE.nonThreshold(this.address(), value);
            return this;
        }

        public Buffer offThreshold(float value) {
            XrInteractionProfileAnalogThresholdVALVE.noffThreshold(this.address(), value);
            return this;
        }

        public Buffer onHaptic(@Nullable @NativeType(value="XrHapticBaseHeader const *") XrHapticBaseHeader value) {
            XrInteractionProfileAnalogThresholdVALVE.nonHaptic(this.address(), value);
            return this;
        }

        public Buffer offHaptic(@Nullable @NativeType(value="XrHapticBaseHeader const *") XrHapticBaseHeader value) {
            XrInteractionProfileAnalogThresholdVALVE.noffHaptic(this.address(), value);
            return this;
        }
    }
}

