/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.ui.icon.internal;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.rest.LocaleService;
import org.openhab.core.io.rest.RESTResource;
import org.openhab.core.ui.icon.IconProvider;
import org.openhab.core.ui.icon.IconSet;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;

@Path(value="iconsets")
@Tag(name="iconsets")
@Component
@JaxrsResource
@JaxrsName(value="iconsets")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class IconSetResource
implements RESTResource {
    public static final String PATH_ICONSETS = "iconsets";
    private final List<IconProvider> iconProviders = new ArrayList<IconProvider>(5);
    private final LocaleService localeService;

    @Activate
    public IconSetResource(@Reference LocaleService localeService) {
        this.localeService = localeService;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addIconProvider(IconProvider iconProvider) {
        this.iconProviders.add(iconProvider);
    }

    protected void removeIconProvider(IconProvider iconProvider) {
        this.iconProviders.remove(iconProvider);
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(operationId="getIconSets", summary="Gets all icon sets.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=IconSet.class)))})})
    public Response getAll(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language) {
        Locale locale = this.localeService.getLocale(language);
        ArrayList<IconSet> iconSets = new ArrayList<IconSet>(this.iconProviders.size());
        for (IconProvider iconProvider : this.iconProviders) {
            iconSets.addAll(iconProvider.getIconSets(locale));
        }
        return Response.ok(iconSets).build();
    }
}

