/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.db;

import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.sql.JDBCDataSourceType;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.Messages;
import ca.sqlpower.swingui.db.DataSourceTypeEditor;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class NewDataSourceTypePanel
implements DataEntryPanel {
    private final JDBCDataSourceType dsType;
    private final JComboBox existingDSTypes;
    private final DataSourceTypeEditor editor;
    private final JPanel panel;
    private JRadioButton blankOption;
    private JRadioButton copyOption;

    public NewDataSourceTypePanel(DataSourceTypeEditor editor, DataSourceCollection collection) {
        this.editor = editor;
        this.dsType = new JDBCDataSourceType();
        this.dsType.setName(Messages.getString("DataSourceTypeEditor.defaultDataSourceName"));
        this.existingDSTypes = new JComboBox<Object>(collection.getDataSourceTypes().toArray());
        this.existingDSTypes.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (c instanceof JLabel && value != null) {
                    ((JLabel)c).setText(((JDBCDataSourceType)value).getName());
                }
                return c;
            }
        });
        this.blankOption = new JRadioButton(new AbstractAction("Blank"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewDataSourceTypePanel.this.existingDSTypes.setEnabled(false);
            }
        });
        this.copyOption = new JRadioButton(new AbstractAction("Copy defaults from.."){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewDataSourceTypePanel.this.existingDSTypes.setEnabled(true);
            }
        });
        ButtonGroup optionGroup = new ButtonGroup();
        optionGroup.add(this.blankOption);
        optionGroup.add(this.copyOption);
        this.blankOption.setSelected(true);
        this.existingDSTypes.setEnabled(false);
        this.panel = this.buildUI();
    }

    private JPanel buildUI() {
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("pref"));
        builder.setDefaultDialogBorder();
        builder.append("New Data Source Type");
        builder.append((Component)this.blankOption);
        builder.append((Component)this.copyOption);
        builder.append((Component)this.existingDSTypes);
        return builder.getPanel();
    }

    @Override
    public boolean applyChanges() {
        JDBCDataSourceType defaultDSType;
        if (this.copyOption.isSelected() && (defaultDSType = (JDBCDataSourceType)this.existingDSTypes.getSelectedItem()) != null && defaultDSType != this.dsType) {
            for (String key : defaultDSType.getPropertyNames()) {
                if ("Name".equals(key)) continue;
                this.dsType.putProperty(key, defaultDSType.getProperty(key));
            }
        }
        this.editor.addDsType(this.dsType);
        return true;
    }

    @Override
    public void discardChanges() {
    }

    @Override
    public JComponent getPanel() {
        return this.panel;
    }

    @Override
    public boolean hasUnsavedChanges() {
        return true;
    }

    void setBlankOptionSelected(boolean selected) {
        this.blankOption.setSelected(selected);
        this.copyOption.setSelected(!selected);
    }

    void setCopyDSType(JDBCDataSourceType copyType) {
        this.existingDSTypes.setSelectedItem(copyType);
    }
}

