/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.spring.remoting;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.client.Client;
import org.codehaus.xfire.client.XFireProxyFactory;
import org.codehaus.xfire.service.Endpoint;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceFactory;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.codehaus.xfire.soap.AbstractSoapBinding;
import org.codehaus.xfire.spring.SpringUtils;
import org.codehaus.xfire.util.Resolver;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class XFireClientFactoryBean
implements FactoryBean,
InitializingBean {
    private static final Log LOG = LogFactory.getLog((Class)XFireClientFactoryBean.class);
    private Object _serviceProxy;
    private Class _serviceClass;
    private ServiceFactory _serviceFactory = new ObjectServiceFactory();
    private String _wsdlDocumentUrl;
    private String _serviceName;
    private String _namespaceUri;
    private String _username;
    private String _password;
    private String _url;
    private QName _endpointName;
    private Map _properties;
    private boolean _lookupServiceOnStartup = true;
    private List outHandlers = null;
    private List inHandlers = null;
    private List faultHandlers = null;

    public Object getObject() throws Exception {
        return this._serviceProxy;
    }

    public Class getObjectType() {
        return this._serviceProxy != null ? this._serviceProxy.getClass() : this.getServiceClass();
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getServiceClass() == null) {
            throw new IllegalStateException("serviceInterface is required");
        }
        if (this.getLookupServiceOnStartup()) {
            this._serviceProxy = this.createClient();
        } else {
            ProxyInterceptor interceptor = new ProxyInterceptor();
            this._serviceProxy = ProxyFactory.getProxy((Class)this.getServiceClass(), (Interceptor)interceptor);
        }
    }

    public ServiceFactory getServiceFactory() {
        return this._serviceFactory;
    }

    public void setServiceFactory(ServiceFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Can not set the service factory to null");
        }
        this._serviceFactory = factory;
    }

    public Class getServiceClass() {
        return this._serviceClass;
    }

    public void setServiceInterface(Class serviceClass) {
        this._serviceClass = serviceClass;
    }

    public Class getServiceInterface() {
        return this._serviceClass;
    }

    public void setServiceClass(Class serviceClass) {
        this._serviceClass = serviceClass;
    }

    public String getWsdlDocumentUrl() {
        return this._wsdlDocumentUrl;
    }

    public void setWsdlDocumentUrl(String wsdlUrl) {
        this._wsdlDocumentUrl = wsdlUrl.trim();
    }

    public String getServiceName() {
        return this._serviceName;
    }

    public void setServiceName(String serviceName) {
        this._serviceName = serviceName;
    }

    public String getNamespaceUri() {
        return this._namespaceUri;
    }

    public void setNamespaceUri(String namespace) {
        this._namespaceUri = namespace;
    }

    public boolean getLookupServiceOnStartup() {
        return this._lookupServiceOnStartup;
    }

    public void setLookupServiceOnStartup(boolean lookupServiceOnStartup) {
        this._lookupServiceOnStartup = lookupServiceOnStartup;
    }

    public String getUsername() {
        return this._username;
    }

    public void setUsername(String username) {
        this._username = username;
    }

    public String getPassword() {
        return this._password;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public Map getProperties() {
        return this._properties;
    }

    public void setProperties(Map properties) {
        this._properties = properties;
    }

    public QName getEndpoint() {
        return this._endpointName;
    }

    public void setEndpoint(QName name) {
        this._endpointName = name;
    }

    public String getUrl() {
        return this._url;
    }

    public void setUrl(String _url) {
        this._url = _url;
    }

    public List getFaultHandlers() {
        return this.faultHandlers;
    }

    public void setFaultHandlers(List faultHandlers) {
        this.faultHandlers = faultHandlers;
    }

    public List getInHandlers() {
        return this.inHandlers;
    }

    public void setInHandlers(List inHandlers) {
        this.inHandlers = inHandlers;
    }

    public List getOutHandlers() {
        return this.outHandlers;
    }

    public void setOutHandlers(List outHandlers) {
        this.outHandlers = outHandlers;
    }

    private Object createClient() throws Exception {
        Object serviceClient = this.makeClient();
        Class interf = this.getServiceInterface();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Created: " + this.toString()));
        }
        Client client = Client.getInstance(serviceClient);
        String username = this.getUsername();
        if (username != null) {
            client.setProperty("username", username);
            String password = this.getPassword();
            client.setProperty("password", password);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Enabled HTTP basic authentication for: " + interf + " with username: " + username));
            }
        }
        this.configureClientHandlers(client);
        return serviceClient;
    }

    private void configureClientHandlers(Client client) {
        if (this.inHandlers != null) {
            client.getInHandlers().addAll(this.inHandlers);
        }
        if (this.outHandlers != null) {
            client.getOutHandlers().addAll(this.outHandlers);
        }
        if (this.faultHandlers != null) {
            client.getFaultHandlers().addAll(this.faultHandlers);
        }
    }

    private Object makeClient() throws Exception {
        Service serviceModel;
        String serviceName = this.getServiceName();
        String namespace = this.getNamespaceUri();
        if (this._wsdlDocumentUrl == null) {
            serviceModel = this.getServiceFactory().create(this.getServiceInterface(), serviceName, namespace, this._properties);
        } else {
            Resolver resolver;
            URI uri;
            QName name = null;
            if (serviceName != null && namespace != null) {
                name = new QName(namespace, serviceName);
            }
            if ((uri = (resolver = new Resolver(this._wsdlDocumentUrl)).getURI()) == null) {
                throw new XFireRuntimeException("Could not resolve uri " + uri);
            }
            serviceModel = this.getServiceFactory().create(this.getServiceInterface(), name, uri.toURL(), this._properties);
        }
        String serviceUrl = this.getUrl();
        if (serviceUrl != null) {
            return new XFireProxyFactory().create(serviceModel, serviceUrl);
        }
        if (this._endpointName == null) {
            this._endpointName = this.findFirstSoapEndpoint(serviceModel.getEndpoints());
        }
        if (this._endpointName != null) {
            Endpoint ep = serviceModel.getEndpoint(this._endpointName);
            if (ep == null) {
                throw new IllegalStateException("Could not find endpoint with name " + this._endpointName + " on service.");
            }
            return new XFireProxyFactory().create(ep);
        }
        throw new IllegalStateException("A WSDL URL or service URL must be supplied.");
    }

    private QName findFirstSoapEndpoint(Collection endpoints) {
        Iterator itr = endpoints.iterator();
        while (itr.hasNext()) {
            Endpoint ep = (Endpoint)itr.next();
            if (!(ep.getBinding() instanceof AbstractSoapBinding)) continue;
            return ep.getName();
        }
        return null;
    }

    protected Definition getWSDLDefinition() throws Exception {
        return WSDLFactory.newInstance().newWSDLReader().readWSDL(this.getWsdlDocumentUrl());
    }

    public String toString() {
        StringBuffer builder = new StringBuffer();
        builder.append("XFire client proxy for: ");
        builder.append(this.getServiceInterface());
        if (this.getUrl() != null) {
            builder.append(" at: ");
            builder.append(this.getUrl());
        }
        return builder.toString();
    }

    private class ProxyInterceptor
    implements MethodInterceptor {
        private Object _serviceClient;

        private ProxyInterceptor() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            if (this._serviceClient == null && AopUtils.isToStringMethod((Method)invocation.getMethod())) {
                return "Un-initialized " + XFireClientFactoryBean.this.toString();
            }
            Method method = invocation.getMethod();
            Object[] args = invocation.getArguments();
            Object client = this.getClient();
            try {
                return method.invoke(client, args);
            }
            catch (InvocationTargetException e) {
                Object target = SpringUtils.getUserTarget(client);
                Client c = Client.getInstance(target);
                StringBuffer callTarget = new StringBuffer(c.getUrl()).append(" arguments: ");
                for (int x = 0; x < args.length; ++x) {
                    callTarget.append(args[x].getClass().getName()).append(" : ").append(args[x].toString()).append(" |");
                }
                Throwable targetException = e.getTargetException();
                if (targetException instanceof XFireRuntimeException) {
                    XFireRuntimeException xfRt = (XFireRuntimeException)targetException;
                    Throwable cause = xfRt.getCause();
                    throw new XFireRuntimeException("Exception while calling: " + callTarget.toString(), cause);
                }
                throw targetException;
            }
        }

        private synchronized Object getClient() throws Exception {
            if (this._serviceClient == null) {
                this._serviceClient = XFireClientFactoryBean.this.createClient();
            }
            return this._serviceClient;
        }
    }
}

