/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.actiontoken.verifyemail;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.util.Objects;
import java.util.stream.Stream;
import org.keycloak.TokenVerifier;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.actiontoken.AbstractActionTokenHandler;
import org.keycloak.authentication.actiontoken.ActionTokenContext;
import org.keycloak.authentication.actiontoken.TokenUtils;
import org.keycloak.authentication.actiontoken.verifyemail.VerifyEmailActionToken;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.sessions.AuthenticationSessionCompoundId;
import org.keycloak.sessions.AuthenticationSessionModel;

public class VerifyEmailActionTokenHandler
extends AbstractActionTokenHandler<VerifyEmailActionToken> {
    public VerifyEmailActionTokenHandler() {
        super("verify-email", VerifyEmailActionToken.class, "staleEmailVerificationLink", EventType.VERIFY_EMAIL, "invalid_token");
    }

    @Override
    public TokenVerifier.Predicate<? super VerifyEmailActionToken>[] getVerifiers(ActionTokenContext<VerifyEmailActionToken> tokenContext) {
        return TokenUtils.predicates(TokenUtils.checkThat(t -> Objects.equals(t.getEmail(), tokenContext.getAuthenticationSession().getAuthenticatedUser().getEmail()), "invalid_email", this.getDefaultErrorMessage()));
    }

    @Override
    public Response handleToken(VerifyEmailActionToken token, ActionTokenContext<VerifyEmailActionToken> tokenContext) {
        UserModel user = tokenContext.getAuthenticationSession().getAuthenticatedUser();
        KeycloakSession session = tokenContext.getSession();
        AuthenticationSessionModel authSession = tokenContext.getAuthenticationSession();
        EventBuilder event = tokenContext.getEvent();
        LoginFormsProvider forms = (LoginFormsProvider)session.getProvider(LoginFormsProvider.class);
        event.event(EventType.VERIFY_EMAIL).detail("email", user.getEmail());
        if (user.isEmailVerified() && !this.isVerifyEmailActionSet(user, authSession)) {
            event.user(user).error("email_already_verified");
            return forms.setAuthenticationSession(authSession).setAttribute("messageHeader", (Object)forms.getMessage("emailVerifiedAlreadyMessageHeader", new Object[]{user.getEmail()})).setInfo("emailVerifiedAlreadyMessage", new Object[]{user.getEmail()}).setUser(user).createInfoPage();
        }
        UriInfo uriInfo = tokenContext.getUriInfo();
        RealmModel realm = tokenContext.getRealm();
        if (tokenContext.isAuthenticationSessionFresh()) {
            token.setCompoundOriginalAuthenticationSessionId(token.getCompoundAuthenticationSessionId());
            String authSessionEncodedId = AuthenticationSessionCompoundId.fromAuthSession((AuthenticationSessionModel)authSession).getEncodedId();
            token.setCompoundAuthenticationSessionId(authSessionEncodedId);
            UriBuilder builder = Urls.actionTokenBuilder(uriInfo.getBaseUri(), token.serialize(session, realm, uriInfo), authSession.getClient().getClientId(), authSession.getTabId(), AuthenticationProcessor.getClientData(session, authSession));
            String confirmUri = builder.build(new Object[]{realm.getName()}).toString();
            return forms.setAuthenticationSession(authSession).setAttribute("messageHeader", (Object)forms.getMessage("confirmEmailAddressVerificationHeader", new Object[]{user.getEmail()})).setSuccess("confirmEmailAddressVerification", new Object[]{user.getEmail()}).setAttribute("actionUri", (Object)confirmUri).setUser(user).createInfoPage();
        }
        user.setEmailVerified(true);
        user.removeRequiredAction(UserModel.RequiredAction.VERIFY_EMAIL);
        authSession.removeRequiredAction(UserModel.RequiredAction.VERIFY_EMAIL);
        String redirectUri = RedirectUtils.verifyRedirectUri(tokenContext.getSession(), token.getRedirectUri(), authSession.getClient());
        if (redirectUri != null) {
            authSession.setAuthNote("SET_REDIRECT_URI_AFTER_REQUIRED_ACTIONS", "true");
            authSession.setRedirectUri(redirectUri);
            authSession.setClientNote("redirect_uri", redirectUri);
        }
        event.success();
        if (token.getCompoundOriginalAuthenticationSessionId() != null) {
            AuthenticationSessionManager asm = new AuthenticationSessionManager(session);
            asm.removeAuthenticationSession(tokenContext.getRealm(), authSession, true);
            return forms.setAuthenticationSession(authSession).setAttribute("messageHeader", (Object)forms.getMessage("emailVerifiedMessageHeader", new Object[]{user.getEmail()})).setSuccess("emailVerifiedMessage", new Object[0]).setUser(user).createInfoPage();
        }
        tokenContext.setEvent(event.clone().removeDetail("email").event(EventType.LOGIN));
        String nextAction = AuthenticationManager.nextRequiredAction(session, authSession, tokenContext.getRequest(), event);
        return AuthenticationManager.redirectToRequiredActions(session, realm, authSession, uriInfo, nextAction);
    }

    private boolean isVerifyEmailActionSet(UserModel user, AuthenticationSessionModel authSession) {
        return Stream.concat(user.getRequiredActionsStream(), authSession.getRequiredActions().stream()).anyMatch(UserModel.RequiredAction.VERIFY_EMAIL.name()::equals);
    }
}

