/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.internal.build.AllowReflection;
import org.hibernate.loader.ast.internal.AbstractMultiIdEntityLoader;
import org.hibernate.loader.ast.internal.ExecutionContextWithSubselectFetchHandler;
import org.hibernate.loader.ast.internal.LoaderHelper;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.MultiKeyLoadHelper;
import org.hibernate.loader.ast.spi.MultiIdLoadOptions;
import org.hibernate.loader.ast.spi.SqlArrayMultiKeyLoader;
import org.hibernate.metamodel.mapping.BasicEntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.metamodel.mapping.internal.SqlTypedMappingImpl;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryOptionsAdapter;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.SqlTypedMappingJdbcParameter;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;
import org.hibernate.sql.results.spi.ManagedResultConsumer;

public class MultiIdEntityLoaderArrayParam<E>
extends AbstractMultiIdEntityLoader<E>
implements SqlArrayMultiKeyLoader {
    private final SqlTypedMapping arraySqlTypedMapping;
    private final JdbcParameter jdbcParameter;
    protected final Object[] idArray;

    @AllowReflection
    public MultiIdEntityLoaderArrayParam(EntityMappingType entityDescriptor, SessionFactoryImplementor sessionFactory) {
        super(entityDescriptor, sessionFactory);
        EntityIdentifierMapping identifierMapping = entityDescriptor.getIdentifierMapping();
        SelectableMapping selectable = identifierMapping.getSelectable(0);
        JdbcMapping jdbcMapping = selectable.getJdbcMapping();
        Class<?> idClass = identifierMapping.getJavaType().getJavaTypeClass();
        this.idArray = (Object[])Array.newInstance(idClass, 0);
        this.arraySqlTypedMapping = new SqlTypedMappingImpl(selectable.getColumnDefinition(), selectable.getLength(), selectable.getPrecision(), selectable.getScale(), selectable.getTemporalPrecision(), MultiKeyLoadHelper.resolveArrayJdbcMapping(jdbcMapping, jdbcMapping.getJdbcJavaType().getJavaTypeClass(), sessionFactory));
        this.jdbcParameter = new SqlTypedMappingJdbcParameter(this.arraySqlTypedMapping);
    }

    @Override
    public BasicEntityIdentifierMapping getIdentifierMapping() {
        return (BasicEntityIdentifierMapping)super.getIdentifierMapping();
    }

    @Override
    protected int maxBatchSize(Object[] ids, MultiIdLoadOptions loadOptions) {
        Integer explicitBatchSize = loadOptions.getBatchSize();
        return explicitBatchSize != null && explicitBatchSize > 0 ? explicitBatchSize : ids.length;
    }

    @Override
    protected void loadEntitiesById(List<Object> idsInBatch, final LockOptions lockOptions, MultiIdLoadOptions loadOptions, SharedSessionContractImplementor session) {
        SessionImplementor statefulSession;
        SelectStatement sqlAst = LoaderSelectBuilder.createSelectBySingleArrayParameter(this.getLoadable(), this.getIdentifierMapping(), session.getLoadQueryInfluencers(), lockOptions, this.jdbcParameter, this.getSessionFactory());
        JdbcParameterBindingsImpl bindings = new JdbcParameterBindingsImpl(1);
        bindings.addBinding(this.jdbcParameter, new JdbcParameterBindingImpl(this.arraySqlTypedMapping.getJdbcMapping(), this.toIdArray(idsInBatch)));
        SqlAstTranslator<JdbcOperationQuerySelect> sqlAstTranslator = this.getSqlAstTranslatorFactory().buildSelectTranslator(this.getSessionFactory(), sqlAst);
        JdbcOperationQuerySelect jdbcOperation = sqlAstTranslator.translate(JdbcParameterBindings.NO_BINDINGS, new QueryOptionsAdapter(){

            @Override
            public LockOptions getLockOptions() {
                return lockOptions;
            }
        });
        this.getJdbcSelectExecutor().executeQuery(jdbcOperation, (JdbcParameterBindings)bindings, (ExecutionContext)new ExecutionContextWithSubselectFetchHandler(session, SubselectFetch.createRegistrationHandler(session.getPersistenceContext().getBatchFetchQueue(), sqlAst, JdbcParametersList.singleton(this.jdbcParameter), bindings), session instanceof SessionImplementor && Boolean.TRUE.equals(loadOptions.getReadOnly(statefulSession = (SessionImplementor)session)), lockOptions), RowTransformerStandardImpl.instance(), null, idsInBatch.size(), ManagedResultConsumer.INSTANCE);
    }

    @Override
    protected void loadEntitiesWithUnresolvedIds(Object[] unresolvableIds, MultiIdLoadOptions loadOptions, LockOptions lockOptions, List<E> results, SharedSessionContractImplementor session) {
        SelectStatement sqlAst = LoaderSelectBuilder.createSelectBySingleArrayParameter(this.getLoadable(), this.getIdentifierMapping(), session.getLoadQueryInfluencers(), lockOptions, this.jdbcParameter, this.getSessionFactory());
        JdbcOperationQuerySelect jdbcSelectOperation = this.getSqlAstTranslatorFactory().buildSelectTranslator(this.getSessionFactory(), sqlAst).translate(JdbcParameterBindings.NO_BINDINGS, QueryOptions.NONE);
        List databaseResults = LoaderHelper.loadByArrayParameter(this.toIdArray(unresolvableIds), sqlAst, jdbcSelectOperation, this.jdbcParameter, this.arraySqlTypedMapping.getJdbcMapping(), null, null, null, lockOptions, session.isDefaultReadOnly(), session);
        results.addAll(databaseResults);
    }

    @Override
    protected Object[] toIdArray(List<Object> ids) {
        return ids.toArray(this.idArray);
    }

    protected Object[] toIdArray(Object[] ids) {
        if (ids.getClass().equals(this.idArray.getClass())) {
            return ids;
        }
        Object[] typedIdArray = Arrays.copyOf(this.idArray, ids.length);
        System.arraycopy(ids, 0, typedIdArray, 0, ids.length);
        return typedIdArray;
    }
}

