/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.internal.function.radix;

import java.util.Objects;
import javax.measure.UnitConverter;
import org.apiguardian.api.API;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.spi.NumberSystem;

@API(status=API.Status.INTERNAL)
public interface Radix {
    public Number multiply(Number var1);

    public Number[] divideAndRemainder(Number var1, boolean var2);

    public static Radix ofNumberFactor(Number number) {
        return new NumberFactorRadix(number);
    }

    public static Radix ofMultiplyConverter(UnitConverter linearUnitConverter) {
        Objects.requireNonNull(linearUnitConverter, "unitConverter cannot be null");
        if (!linearUnitConverter.isLinear()) {
            throw new IllegalArgumentException("unitConverter is expected to be a linear transformation (a linear function without offset)");
        }
        Number radix = Calculus.currentNumberSystem().narrow(linearUnitConverter.convert(1.0));
        return new NumberFactorRadix(radix);
    }

    public static class NumberFactorRadix
    implements Radix {
        private final Number radix;

        public NumberFactorRadix(Number radix) {
            this.radix = NumberFactorRadix.ns().narrow(radix);
        }

        @Override
        public Number multiply(Number number) {
            Number result = NumberFactorRadix.ns().multiply(this.radix, NumberFactorRadix.ns().narrow(number));
            return NumberFactorRadix.ns().narrow(result);
        }

        @Override
        public Number[] divideAndRemainder(Number number, boolean roundRemainderTowardsZero) {
            Number[] result = NumberFactorRadix.ns().divideAndRemainder(NumberFactorRadix.ns().narrow(number), this.radix, roundRemainderTowardsZero);
            result[0] = NumberFactorRadix.ns().narrow(result[0]);
            result[1] = NumberFactorRadix.ns().narrow(result[1]);
            return result;
        }

        private static NumberSystem ns() {
            return Calculus.currentNumberSystem();
        }
    }
}

