/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * mix(vec2(-2.0, -2.0), vec2(-3.0, 3.0), 0.0) => vec2(-2.0, -2.0)
 * mix(vec2(2.0, 2.0), vec2(-3.0, 3.0), 0.0) => vec2(2.0, 2.0)
 * mix(vec2(-2.0, -2.0), vec2(-3.0, 3.0), 0.33333334) => vec2(-2.3333333, -0.33333328)
 * mix(vec2(2.0, 2.0), vec2(-3.0, 3.0), 0.33333334) => vec2(0.33333328, 2.3333333)
 * mix(vec2(-2.0, -2.0), vec2(-3.0, 3.0), 0.6666667) => vec2(-2.6666667, 1.3333335)
 * mix(vec2(2.0, 2.0), vec2(-3.0, 3.0), 0.6666667) => vec2(-1.3333335, 2.6666667)
 * mix(vec2(-2.0, -2.0), vec2(-3.0, 3.0), 1.0) => vec2(-3.0, 3.0)
 * mix(vec2(2.0, 2.0), vec2(-3.0, 3.0), 1.0) => vec2(-3.0, 3.0)
 */
#version 150

void main()
{
  float[distance(mix(vec2(-2.0, -2.0), vec2(-3.0, 3.0), 0.0), vec2(-2.0, -2.0)) <= 2.828427e-05 ? 1 : -1] array0;
  float[distance(mix(vec2(2.0, 2.0), vec2(-3.0, 3.0), 0.0), vec2(2.0, 2.0)) <= 2.828427e-05 ? 1 : -1] array1;
  float[distance(mix(vec2(-2.0, -2.0), vec2(-3.0, 3.0), 0.33333334), vec2(-2.3333333, -0.33333328)) <= 2.3570226e-05 ? 1 : -1] array2;
  float[distance(mix(vec2(2.0, 2.0), vec2(-3.0, 3.0), 0.33333334), vec2(0.33333328, 2.3333333)) <= 2.3570226e-05 ? 1 : -1] array3;
  float[distance(mix(vec2(-2.0, -2.0), vec2(-3.0, 3.0), 0.6666667), vec2(-2.6666667, 1.3333335)) <= 2.981424e-05 ? 1 : -1] array4;
  float[distance(mix(vec2(2.0, 2.0), vec2(-3.0, 3.0), 0.6666667), vec2(-1.3333335, 2.6666667)) <= 2.981424e-05 ? 1 : -1] array5;
  float[distance(mix(vec2(-2.0, -2.0), vec2(-3.0, 3.0), 1.0), vec2(-3.0, 3.0)) <= 4.2426407e-05 ? 1 : -1] array6;
  float[distance(mix(vec2(2.0, 2.0), vec2(-3.0, 3.0), 1.0), vec2(-3.0, 3.0)) <= 4.2426407e-05 ? 1 : -1] array7;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
