/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.spec;

import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import java.util.Map;
import java.util.function.Function;

public class McpError
extends RuntimeException {
    public static final Function<String, McpError> RESOURCE_NOT_FOUND = resourceUri -> new McpError(new McpSchema.JSONRPCResponse.JSONRPCError(-32002, "Resource not found", Map.of("uri", resourceUri)));
    private McpSchema.JSONRPCResponse.JSONRPCError jsonRpcError;

    public McpError(McpSchema.JSONRPCResponse.JSONRPCError jsonRpcError) {
        super(jsonRpcError.message());
        this.jsonRpcError = jsonRpcError;
    }

    @Deprecated
    public McpError(Object error) {
        super(error.toString());
    }

    public McpSchema.JSONRPCResponse.JSONRPCError getJsonRpcError() {
        return this.jsonRpcError;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        if (this.jsonRpcError != null) {
            builder.append("\n");
            builder.append(this.jsonRpcError.toString());
        }
        return builder.toString();
    }

    public static Builder builder(int errorCode) {
        return new Builder(errorCode);
    }

    public static Throwable findRootCause(Throwable throwable) {
        Throwable rootCause;
        Assert.notNull(throwable, "throwable must not be null");
        for (rootCause = throwable; rootCause.getCause() != null && rootCause.getCause() != rootCause; rootCause = rootCause.getCause()) {
        }
        return rootCause;
    }

    public static String aggregateExceptionMessages(Throwable throwable) {
        Assert.notNull(throwable, "throwable must not be null");
        StringBuilder messages = new StringBuilder();
        for (Throwable current = throwable; current != null; current = current.getCause()) {
            if (messages.length() > 0) {
                messages.append("\n  Caused by: ");
            }
            messages.append(current.getClass().getSimpleName());
            if (current.getMessage() != null) {
                messages.append(": ").append(current.getMessage());
            }
            if (current.getCause() == current) break;
        }
        return messages.toString();
    }

    public static class Builder {
        private final int code;
        private String message;
        private Object data;

        private Builder(int code) {
            this.code = code;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder data(Object data) {
            this.data = data;
            return this;
        }

        public McpError build() {
            Assert.hasText(this.message, "message must not be empty");
            return new McpError(new McpSchema.JSONRPCResponse.JSONRPCError(this.code, this.message, this.data));
        }
    }
}

