/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.credentials;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.auth.credentials.internal.SystemSettingsCredentialsProvider;
import software.amazon.awssdk.core.useragent.BusinessMetricFeatureId;
import software.amazon.awssdk.utils.SystemSetting;
import software.amazon.awssdk.utils.ToString;

@SdkPublicApi
public final class SystemPropertyCredentialsProvider
extends SystemSettingsCredentialsProvider {
    private static final String CLASS_NAME = "SystemPropertyCredentialsProvider";
    private static final String PROVIDER_NAME = BusinessMetricFeatureId.CREDENTIALS_JVM_SYSTEM_PROPERTIES.value();

    private SystemPropertyCredentialsProvider() {
    }

    public static SystemPropertyCredentialsProvider create() {
        return new SystemPropertyCredentialsProvider();
    }

    @Override
    protected Optional<String> loadSetting(SystemSetting setting) {
        return Optional.ofNullable(System.getProperty(setting.property()));
    }

    @Override
    protected String provider() {
        return PROVIDER_NAME;
    }

    public String toString() {
        return ToString.create((String)CLASS_NAME);
    }
}

