/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.ConversionTaskDescription;
import com.amazon.aes.webservices.client.ImportVolumeConversionTask;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.GeneralError;
import com.amazon.aes.webservices.client.cmd.Outputter;
import com.amazon.aes.webservices.client.cmd.util.S3ProxyUtil;
import com.amazon.aes.webservices.client.vmconversion.AsciiProgressBar;
import com.amazon.aes.webservices.client.vmconversion.InternalException;
import com.amazon.aes.webservices.client.vmconversion.ManifestFactory;
import com.amazon.aes.webservices.client.vmconversion.VerificationException;
import com.amazon.aes.webservices.client.vmconversionschema.Manifest;
import com.amazon.aes.webservices.client.vmconversionschema.Part;
import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DeleteDiskImage
extends BaseCmd {
    public static final String[] OWNER_SAK_DESC_ = new String[]{"AWS Secret Access Key of the owner of BUCKET, used to access S3 for deleting", "the uploaded-disk-image. This parameter value is not sent to EC2. [REQUIRED]."};
    public static final String[] IMPORT_URL_DESC = new String[]{"Specify the URL for an existing import-manifest file. Using this option to", "delete the uploaded disk-image irrespective whether one or more active", "conversion tasks still reference the said manifest. [REQUIRED] unless the", "'task' option has been specified."};
    public static final String[] MANIFEST_SPEC_ATTRIBUES = new String[]{"task", "manifest-url"};
    public static final String[] TASK_DESC = new String[]{"Task-ID of the conversion task that is no longer active. [REQUIRED] unless", "the 'manifest-url' option has been specified."};
    public static final String IGNORE_ACTIVE_TASK = "ignore-active-task";
    public static final String[] IGNORE_ACTIVE_TASK_DESC = new String[]{"Delete the uploaded disk-image despite having an active task. [OPTIONAL]", "Using this option may cause active taskss to fail. USE AT YOUR OWN RISK."};
    private static final String PART_SUFFIX = "part";
    protected URL manifestUrl;
    protected String s3AccessId;
    protected String s3SecretKey;
    protected AmazonS3Client s3Client;
    protected String taskId;
    protected boolean ignoreActiveTask;
    protected String bucketName;
    protected Manifest manifest;
    protected S3Object manifestS3Object;

    public DeleteDiskImage(String short_form, String long_form) {
        super(short_form, long_form);
    }

    public DeleteDiskImage(String[] args) {
        super("ec2ddi", "ec2-delete-disk-image");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"manifest-url");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"url");
        OptionBuilder.withDescription((String)DeleteDiskImage.joinDescription(IMPORT_URL_DESC));
        options.addOption(OptionBuilder.create((String)"u"));
        OptionBuilder.withLongOpt((String)"owner-akid");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"OWNERAKID");
        OptionBuilder.withDescription((String)this.joinDescription("AWS Access Key Id of the owner of BUCKET."));
        options.addOption(OptionBuilder.create((String)"o"));
        OptionBuilder.withLongOpt((String)"owner-sak");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"SECRETKEY");
        OptionBuilder.withDescription((String)DeleteDiskImage.joinDescription(OWNER_SAK_DESC_));
        options.addOption(OptionBuilder.create((String)"w"));
        OptionBuilder.withLongOpt((String)"task");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"TASK-ID");
        OptionBuilder.withDescription((String)DeleteDiskImage.joinDescription(TASK_DESC));
        options.addOption(OptionBuilder.create((String)"t"));
        OptionBuilder.withLongOpt((String)IGNORE_ACTIVE_TASK);
        OptionBuilder.withDescription((String)DeleteDiskImage.joinDescription(IGNORE_ACTIVE_TASK_DESC));
        options.addOption(OptionBuilder.create());
        return options;
    }

    @Override
    protected String getOptionString() {
        return "[SPECIFIC OPTIONS]";
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("task");
        this.printOption("manifest-url");
        this.printOption("owner-akid");
        this.printOption("owner-sak");
        this.printOption(IGNORE_ACTIVE_TASK);
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Delete a partially or fully uploaded disk-image for conversion-tasks ");
        System.out.println("     from S3. You can either specify the TASK-ID for the conversion task, or");
        System.out.println("     provide the URL to the import-manifest file in S3.");
    }

    public void validateAndSetupS3Access() throws GeneralError {
        this.assertOptionSet("owner-akid");
        this.s3AccessId = this.getOptionValue("owner-akid");
        this.assertOptionSet("owner-sak");
        this.s3SecretKey = this.getOptionValue("owner-sak");
        String region = this.extractRegionFromUrl(this.getURL());
        ClientConfiguration clientConfig = new ClientConfiguration();
        S3ProxyUtil.populateS3ProxyProperties(clientConfig, this.getURL(), this.isOptionSet("verbose"));
        if (SIGV2_REGIONS.contains(region)) {
            this.s3Client = new AmazonS3Client((AWSCredentials)new BasicAWSCredentials(this.s3AccessId, this.s3SecretKey), clientConfig);
            if ("us-gov-west-1".equals(region)) {
                this.s3Client.setRegion(Region.getRegion((Regions)Regions.GovCloud));
            }
        } else {
            clientConfig = clientConfig.withSignerOverride("AWSS3V4SignerType");
            String endpoint = this.getURL().replaceFirst("ec2", "s3");
            this.s3Client.setEndpoint(endpoint, "s3", region);
        }
    }

    protected void validateParameters() throws VerificationException {
        this.validateAndSetupS3Access();
        this.assertOnlyOneOptionSet(MANIFEST_SPEC_ATTRIBUES);
        String manifestStr = null;
        if (this.isOptionSet("manifest-url")) {
            manifestStr = this.getOptionValue("manifest-url");
            try {
                this.manifestUrl = new URL(manifestStr);
            }
            catch (MalformedURLException e) {
                throw new VerificationException("The specified manifest-url " + manifestStr + " is malformed");
            }
        } else {
            this.taskId = this.getOptionValue("task");
            this.ignoreActiveTask = this.isOptionSet(IGNORE_ACTIVE_TASK);
        }
    }

    protected URL validateAndGetUrlFromTask(Jec2 jec2) throws Exception {
        ConversionTaskDescription task = jec2.describeConversionTask(this.taskId);
        ImportVolumeConversionTask importTask = null;
        String tasktype = task.getTaskType();
        if (tasktype.equals("ImportVolume")) {
            importTask = task.getImportVolumeConversionTask();
        } else if (tasktype.equals("ImportInstance")) {
            importTask = (ImportVolumeConversionTask)task.getImportInstanceConversionTask().getVolumes().get(0);
        } else {
            throw new GeneralError("The task ID " + task + " is not a known task type.");
        }
        if (importTask == null) {
            throw new GeneralError("The task ID " + task + " has no details for retriving the manifest URL");
        }
        if (task.getStatus().equalsIgnoreCase("active") && !this.ignoreActiveTask) {
            throw new GeneralError("The task " + this.taskId + " is still active. Use --" + IGNORE_ACTIVE_TASK + " to force the deletion.");
        }
        try {
            return new URL(importTask.getImportManifestUrl());
        }
        catch (MalformedURLException e) {
            throw new GeneralError("The task ID " + task + " has an invalid import-manifest-url");
        }
    }

    protected Manifest getManifestIfExists() throws GeneralError {
        Manifest manifest;
        block12: {
            manifest = null;
            try {
                this.manifestS3Object = ManifestFactory.getManifestS3Object((URL)this.manifestUrl);
            }
            catch (URISyntaxException e) {
                throw new InternalException("Cannot determine if manifest file exists. " + e.getMessage());
            }
            this.bucketName = ManifestFactory.getBucketName((S3Object)this.manifestS3Object);
            try {
                boolean manifestExists;
                try {
                    this.s3Client.getObjectMetadata(this.bucketName, this.manifestS3Object.getKey());
                    manifestExists = true;
                }
                catch (AmazonServiceException e) {
                    switch (e.getStatusCode()) {
                        case 403: {
                            manifestExists = true;
                            break;
                        }
                        case 404: {
                            manifestExists = false;
                            break;
                        }
                        default: {
                            throw e;
                        }
                    }
                }
                if (!manifestExists) break block12;
                try {
                    S3Object manifestObj = this.s3Client.getObject(this.bucketName, this.manifestS3Object.getKey());
                    ManifestFactory mf = new ManifestFactory((AmazonS3)this.s3Client);
                    manifest = mf.loadExistingManifest(manifestObj);
                }
                catch (Exception e) {
                    throw new GeneralError("Unable to load manifest at " + this.bucketName + "/" + this.manifestS3Object.getKey());
                }
            }
            catch (AmazonClientException e) {
                throw new InternalException("Cannot determine if manifest file exists. " + e.getMessage());
            }
        }
        return manifest;
    }

    private String getCommonPrefix() throws VerificationException {
        Part part = (Part)this.manifest.getImport().getParts().getPart().get(0);
        String prefix = part.getKey().replaceFirst("part\\d+$", PART_SUFFIX);
        if (!prefix.endsWith(PART_SUFFIX)) {
            throw new VerificationException("Unable to determine common prefix for " + part.getKey());
        }
        return prefix;
    }

    private Map<String, S3ObjectSummary> findExistingParts(String prefix) throws AmazonServiceException, AmazonClientException {
        HashMap<String, S3ObjectSummary> existingParts = new HashMap<String, S3ObjectSummary>();
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest();
        listObjectsRequest.setBucketName(this.bucketName);
        listObjectsRequest.setPrefix(prefix);
        ObjectListing listObjectsResponse = null;
        do {
            listObjectsResponse = this.s3Client.listObjects(listObjectsRequest);
            for (S3ObjectSummary objectSummary : listObjectsResponse.getObjectSummaries()) {
                existingParts.put(objectSummary.getKey(), objectSummary);
            }
            listObjectsRequest.setMarker(listObjectsResponse.getNextMarker());
        } while (listObjectsResponse.isTruncated());
        return existingParts;
    }

    public void deleteManifestParts() throws VerificationException, GeneralError {
        Map<String, S3ObjectSummary> existingParts;
        String prefix = this.getCommonPrefix();
        try {
            existingParts = this.findExistingParts(prefix);
        }
        catch (AmazonClientException e) {
            throw new GeneralError("Unexpected error while processing the manifest. Please retry");
        }
        long start = System.currentTimeMillis();
        ExecutorService executorsProgressBar = Executors.newFixedThreadPool(1);
        AsciiProgressBar progressBar = new AsciiProgressBar((long)(existingParts.size() + 1), start, AsciiProgressBar.BarCallerType.DISKDELETER, System.out);
        progressBar.preamble();
        Future<?> futureProgressBar = executorsProgressBar.submit((Runnable)progressBar);
        int partsCounter = 0;
        for (Map.Entry<String, S3ObjectSummary> pairs : existingParts.entrySet()) {
            this.deleteS3Object(pairs.getValue().getKey());
            progressBar.updateCompleted((long)(++partsCounter));
        }
        this.deleteS3Object(this.manifestS3Object.getKey());
        progressBar.updateCompleted((long)(++partsCounter));
        while (true) {
            if (!futureProgressBar.isDone()) {
                continue;
            }
            try {
                futureProgressBar.get();
            }
            catch (Exception e) {
                continue;
            }
            break;
        }
        progressBar.postamble();
        executorsProgressBar.shutdownNow();
    }

    private void deleteS3Object(String objectKey) throws GeneralError {
        try {
            this.s3Client.deleteObject(this.bucketName, objectKey);
        }
        catch (AmazonClientException e) {
            throw new GeneralError("Could not delete " + objectKey + ". Please retry");
        }
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        try {
            this.validateParameters();
            if (this.manifestUrl == null) {
                this.manifestUrl = this.validateAndGetUrlFromTask(jec2);
            }
            this.manifest = this.getManifestIfExists();
            if (this.manifest == null) {
                System.out.println("The manifest file does not exist. Nothing to delete");
            } else {
                this.deleteManifestParts();
            }
            return true;
        }
        catch (VerificationException e) {
            System.err.println("ERROR: " + e.getMessage());
            return false;
        }
        catch (InternalException e) {
            System.err.println("ERROR: " + e.getMessage());
            return false;
        }
    }

    public static void main(String[] args) {
        new DeleteDiskImage(args).invoke();
    }
}

