
package Protobuf;

# Copyright 2025 Google LLC and contributors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

use strict;
use warnings;
use namespace::autoclean;

our $VERSION = '0.001';

1;
__END__

=head1 NAME

Protobuf - Namespace reservation for Google's Protocol Buffers

=head1 SYNOPSIS

  # This module currently does nothing but reserve the namespace.
  use Protobuf;

=head1 DESCRIPTION

This module reserves the C<Protobuf> namespace on CPAN for future
development of Perl bindings for Google's Protocol Buffers.

Protocol Buffers are a language-neutral, platform-neutral, extensible
mechanism for serializing structured data.

=head1 AUTHOR

C.J. Collier <cjac@colliertech.org>

=head1 COPYRIGHT AND LICENSE

Copyright 2025 Google LLC and contributors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

=cut
